<?php
session_start();
require_once 'config.php';

// Segurança Master
if (!isset($_SESSION['nivel']) || $_SESSION['nivel'] != 'admin') { 
    header("Location: fretes.php"); exit(); 
}

// --- ATUALIZAR PORCENTAGEM DE COMISSÃO ---
if (isset($_POST['update_config'])) {
    $nova_comissao = $_POST['comissao_porcentagem'];
    $pdo->prepare("UPDATE configuracoes SET comissao_porcentagem = ? WHERE id = 1")->execute([$nova_comissao]);
    header("Location: admin.php"); exit();
}

$comissao_pct = $pdo->query("SELECT comissao_porcentagem FROM configuracoes WHERE id = 1")->fetchColumn() ?: 10;

// --- AÇÕES DE EXCLUSÃO, ADMIN E PAGAMENTO ---
if (isset($_GET['excluir_id'])) {
    $id_excluir = $_GET['excluir_id'];
    $pdo->prepare("DELETE FROM pagamentos WHERE usuario_id = ?")->execute([$id_excluir]);
    $pdo->prepare("DELETE FROM saques WHERE usuario_id = ?")->execute([$id_excluir]);
    $pdo->prepare("DELETE FROM usuarios WHERE id = ?")->execute([$id_excluir]);
    header("Location: admin.php"); exit();
}

if (isset($_POST['add_admin'])) {
    $senha_hash = password_hash($_POST['senha'], PASSWORD_DEFAULT);
    $pdo->prepare("INSERT INTO usuarios (nome, email, senha, whatsapp, nivel, status) VALUES (?, ?, ?, ?, 'admin', 'ativo')")->execute([$_POST['nome'], $_POST['email'], $senha_hash, $_POST['whatsapp']]);
    header("Location: admin.php"); exit();
}

if (isset($_POST['editar_usuario'])) {
    $pdo->prepare("UPDATE usuarios SET nome = ?, email = ?, whatsapp = ?, codigo_indicacao = ?, nivel = ? WHERE id = ?")->execute([$_POST['nome'], $_POST['email'], $_POST['whatsapp'], $_POST['codigo_indicacao'], $_POST['nivel'], $_POST['user_id']]);
    header("Location: admin.php"); exit();
}

if (isset($_POST['registrar_pagamento'])) {
    $pdo->prepare("INSERT INTO pagamentos (usuario_id, valor, data_pagamento) VALUES (?, ?, ?)")->execute([$_POST['user_id'], $_POST['valor'], $_POST['data_pago']]);
    $pdo->prepare("UPDATE usuarios SET status = 'pago', plano = ? WHERE id = ?")->execute([$_POST['plano'], $_POST['user_id']]);
    header("Location: admin.php"); exit();
}

// --- MELHORIA: APROVAR SAQUE E REGISTRAR DATA (SUBTRAI DO SALDO) ---
if (isset($_GET['aprovar_saque'])) {
    $pdo->prepare("UPDATE saques SET status = 'Pago', data_pagamento = NOW() WHERE id = ?")->execute([$_GET['aprovar_saque']]);
    header("Location: admin.php"); exit();
}

// --- MELHORIA: BAIXA MANUAL DE COMISSÃO (SUBTRAI DO SALDO) ---
if (isset($_POST['baixa_comissao_manual'])) {
    $pdo->prepare("INSERT INTO saques (usuario_id, valor, status, data_pagamento) VALUES (?, ?, 'Pago', NOW())")->execute([$_POST['user_id'], $_POST['valor_saque']]);
    header("Location: admin.php"); exit();
}

// --- BUSCAS ---
$f_inicio = $_GET['f_inicio'] ?? date('Y-m-01');
$f_fim = $_GET['f_fim'] ?? date('Y-m-t');
$receita_total = $pdo->query("SELECT SUM(valor) FROM pagamentos WHERE data_pagamento BETWEEN '$f_inicio' AND '$f_fim'")->fetchColumn() ?: 0;

$usuarios = $pdo->query("SELECT *, DATE_FORMAT(data_cadastro, '%d/%m/%Y') as data_f FROM usuarios WHERE nivel != 'admin' ORDER BY data_cadastro DESC")->fetchAll(PDO::FETCH_ASSOC);
$admins = $pdo->query("SELECT * FROM usuarios WHERE nivel = 'admin'")->fetchAll(PDO::FETCH_ASSOC);

try {
    // Melhorado para pegar apenas os que estão em análise/pendentes
    $saques_pendentes = $pdo->query("SELECT s.*, u.nome, u.whatsapp, u.pix FROM saques s JOIN usuarios u ON s.usuario_id = u.id WHERE s.status IN ('Analisando', 'Pendente') ORDER BY s.id DESC")->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $saques_pendentes = [];
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Admin - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input, select { background: #0f172a !important; color: white !important; border: 1px solid #1e293b !important; }
    </style>
</head>
<body class="text-slate-100 p-4 md:p-8">

    <div class="max-w-7xl mx-auto">
        <header class="flex justify-between items-center mb-10">
            <h1 class="text-2xl font-black italic uppercase text-orange-500">ROTA PRIME <span class="text-white text-sm tracking-widest">CONTROL</span></h1>
            <div class="flex gap-2">
                <button onclick="document.getElementById('modal_admin').showModal()" class="bg-blue-600 text-white px-4 py-2 rounded-xl text-[10px] font-black uppercase shadow-lg">+ Novo Admin</button>
                <a href="logout.php" class="bg-red-500/10 text-red-500 px-4 py-2 rounded-xl text-[10px] font-black uppercase">Sair</a>
            </div>
        </header>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-10">
            <div class="glass p-6 rounded-[32px] md:col-span-2">
                <form method="GET" class="flex flex-col md:flex-row items-end gap-4">
                    <div class="flex-1 w-full">
                        <label class="text-[10px] text-slate-500 uppercase font-black mb-2 block tracking-widest italic">Período de Receita</label>
                        <div class="flex gap-2">
                            <input type="date" name="f_inicio" value="<?php echo $f_inicio; ?>" class="p-3 rounded-xl w-full text-xs text-orange-400 outline-none">
                            <input type="date" name="f_fim" value="<?php echo $f_fim; ?>" class="p-3 rounded-xl w-full text-xs text-orange-400 outline-none">
                        </div>
                    </div>
                    <button type="submit" class="bg-slate-800 text-white px-8 py-3 rounded-xl font-black text-xs uppercase hover:bg-orange-500 transition w-full md:w-auto">Filtrar</button>
                </form>
            </div>

            <div class="glass p-6 rounded-[32px] border-l-4 border-blue-500">
                <form method="POST">
                    <label class="text-[10px] text-slate-500 uppercase font-black mb-2 block tracking-widest italic">Comissão (%)</label>
                    <div class="flex gap-2">
                        <input type="number" step="0.1" name="comissao_porcentagem" value="<?php echo $comissao_pct; ?>" class="p-3 rounded-xl w-full text-xs text-blue-400 font-bold outline-none">
                        <button type="submit" name="update_config" class="bg-blue-600 text-white px-4 rounded-xl hover:bg-blue-500 transition"><i class="fas fa-percent"></i></button>
                    </div>
                </form>
            </div>

            <div class="bg-orange-500 p-6 rounded-[32px] flex flex-col justify-center shadow-xl shadow-orange-500/20">
                <p class="text-slate-950 text-[10px] uppercase font-black tracking-widest mb-1 opacity-70">Receita Total</p>
                <h3 class="text-3xl font-black italic text-slate-950">R$ <?php echo number_format($receita_total, 2, ',', '.'); ?></h3>
            </div>
        </div>

        <?php if (!empty($saques_pendentes)): ?>
        <div class="mb-10">
            <h2 class="text-xs font-black uppercase text-orange-500 mb-4 tracking-widest italic">Solicitações de Saque</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <?php foreach($saques_pendentes as $s): ?>
                <div class="glass p-5 rounded-[24px] border border-orange-500/30">
                    <p class="font-black text-xs uppercase mb-1"><?php echo $s['nome']; ?></p>
                    <div class="bg-black/20 p-2 rounded-lg mb-2">
                        <p class="text-[9px] text-slate-500 uppercase font-black">Chave PIX (CPF):</p>
                        <p class="text-sm font-mono text-emerald-400"><?php echo $s['pix'] ?: 'Não informado'; ?></p>
                    </div>
                    <p class="text-xl font-black text-emerald-400 my-1 leading-none">R$ <?php echo number_format($s['valor'], 2, ',', '.'); ?></p>
                    <a href="?aprovar_saque=<?php echo $s['id']; ?>" class="block w-full bg-emerald-600 text-center py-2 rounded-xl text-[9px] font-black uppercase mt-2 hover:bg-emerald-500 transition">Dar Baixa no Saque</a>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <div class="glass rounded-[32px] overflow-hidden border border-slate-800 shadow-2xl">
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead class="bg-slate-900/50 text-slate-500 text-[9px] uppercase tracking-widest">
                        <tr>
                            <th class="p-6">Informações do Usuário</th>
                            <th class="p-6">Chave PIX / Registro</th>
                            <th class="p-6 text-orange-500">Saldo Atual (<?php echo $comissao_pct; ?>%)</th>
                            <th class="p-6">Status Assinatura</th>
                            <th class="p-6">Status Saque</th>
                            <th class="p-6">Baixa Manual</th>
                            <th class="p-6 text-right">Gestão</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-800">
                        <?php foreach($usuarios as $u): 
                            // Lógica de saldo subtraindo o que já foi pago
                            $stmt = $pdo->prepare("SELECT SUM(p.valor) FROM pagamentos p JOIN usuarios u ON p.usuario_id = u.id WHERE u.indicado_por = ?");
                            $stmt->execute([$u['codigo_indicacao']]);
                            $total_indicados_pagaram = $stmt->fetchColumn() ?: 0;
                            $ganho_total = ($total_indicados_pagaram * $comissao_pct) / 100;
                            
                            $pago_ja = $pdo->query("SELECT SUM(valor) FROM saques WHERE usuario_id = {$u['id']} AND status = 'Pago'")->fetchColumn() ?: 0;
                            $saldo_real = $ganho_total - $pago_ja;

                            // Busca último status de saque
                            $ultimo_saque = $pdo->query("SELECT status FROM saques WHERE usuario_id = {$u['id']} ORDER BY id DESC LIMIT 1")->fetchColumn();
                        ?>
                        <tr class="hover:bg-slate-800/30 transition">
                            <td class="p-6">
                                <div class="font-bold text-slate-200"><?php echo $u['nome']; ?></div>
                                <div class="text-[10px] text-orange-400 font-bold"><?php echo $u['whatsapp']; ?></div>
                                <div class="text-[10px] text-slate-500 font-medium"><?php echo $u['email']; ?></div>
                                <div class="text-[8px] text-slate-600 uppercase font-black mt-1"><?php echo $u['nivel']; ?> | <?php echo $u['codigo_empresa']; ?></div>
                            </td>
                            <td class="p-6">
                                <p class="text-[10px] text-slate-500 uppercase font-black mb-1">PIX (CPF):</p>
                                <div class="text-xs font-mono text-blue-400 font-bold mb-2"><?php echo $u['pix'] ?: 'Não informado'; ?></div>
                                <p class="text-[10px] text-slate-500 uppercase font-black mb-1">Cadastrado em:</p>
                                <div class="text-[10px] text-slate-400"><?php echo $u['data_f']; ?></div>
                            </td>
                            <td class="p-6">
                                <div class="text-xl font-black text-emerald-400 leading-none">R$ <?php echo number_format($saldo_real, 2, ',', '.'); ?></div>
                                <div class="text-[8px] text-slate-600 uppercase mt-1 italic">Total Pago: R$ <?php echo number_format($pago_ja, 2, ',', '.'); ?></div>
                            </td>
                            <td class="p-6">
                                <?php if($u['status'] == 'pago'): ?>
                                    <span class="bg-blue-500/10 text-blue-500 text-[9px] font-black px-2 py-1 rounded-lg uppercase"><?php echo $u['plano'] ?: 'Ativo'; ?></span>
                                <?php else: ?>
                                    <span class="text-[9px] text-orange-500 font-black uppercase italic animate-pulse">Pendente</span>
                                <?php endif; ?>
                            </td>
                            <td class="p-6">
                                <?php if($ultimo_saque == 'Pago'): ?>
                                    <span class="bg-emerald-500/10 text-emerald-500 text-[9px] font-black px-2 py-1 rounded-lg uppercase border border-emerald-500/20">Pago</span>
                                <?php elseif($ultimo_saque): ?>
                                    <span class="bg-yellow-500/10 text-yellow-500 text-[9px] font-black px-2 py-1 rounded-lg uppercase border border-yellow-500/20 italic animate-bounce">Pendente</span>
                                <?php else: ?>
                                    <span class="text-[9px] text-slate-600 uppercase font-black">Nenhum</span>
                                <?php endif; ?>
                            </td>
                            <td class="p-6">
                                <div class="flex flex-col gap-2">
                                    <form method="POST" class="flex gap-1">
                                        <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                                        <input type="number" step="0.01" name="valor" placeholder="Assin." class="rounded-lg p-1 text-[10px] w-12 outline-none" required>
                                        <select name="plano" class="text-[10px] rounded-lg p-1 outline-none">
                                            <option value="Mensal">M</option>
                                            <option value="Anual">A</option>
                                        </select>
                                        <input type="hidden" name="data_pago" value="<?php echo date('Y-m-d'); ?>">
                                        <button type="submit" name="registrar_pagamento" class="bg-blue-600 text-white px-2 rounded-lg text-[9px] font-black uppercase hover:bg-blue-500 transition">OK</button>
                                    </form>
                                    
                                    <form method="POST" class="flex gap-1">
                                        <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                                        <input type="number" step="0.01" name="valor_saque" placeholder="Comiss." class="rounded-lg p-1 text-[10px] w-12 outline-none border border-emerald-500/30" required>
                                        <button type="submit" name="baixa_comissao_manual" class="bg-emerald-600 text-white px-2 rounded-lg text-[9px] font-black uppercase hover:bg-emerald-500 transition">Baixa PIX</button>
                                    </form>
                                </div>
                            </td>
                            <td class="p-6 text-right space-x-2">
                                <button onclick='abrirEdicao(<?php echo json_encode($u); ?>)' class="text-blue-400 p-1 hover:text-white transition"><i class="fas fa-edit"></i></button>
                                <button onclick="confirmarExclusao(<?php echo $u['id']; ?>, '<?php echo $u['nome']; ?>')" class="text-red-500 p-1 hover:text-red-300 transition"><i class="fas fa-trash-alt"></i></button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="mt-12 mb-10">
            <h2 class="text-xs font-black uppercase text-blue-500 mb-4 tracking-widest italic">Gestores</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <?php foreach($admins as $a): ?>
                <div class="glass p-4 rounded-2xl border-l-2 border-blue-600">
                    <p class="text-xs font-black"><?php echo $a['nome']; ?></p>
                    <p class="text-[8px] text-slate-500 uppercase"><?php echo $a['email']; ?></p>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <dialog id="modal_editar" class="glass rounded-[32px] p-8 text-slate-100 w-full max-w-md">
        <h3 class="text-xl font-black italic uppercase text-blue-500 mb-6">Editar Usuário</h3>
        <form method="POST" class="flex flex-col gap-4">
            <input type="hidden" name="user_id" id="edit_id">
            <input type="text" name="nome" id="edit_nome" class="p-3 rounded-xl border border-slate-700 text-sm w-full" placeholder="Nome">
            <input type="email" name="email" id="edit_email" class="p-3 rounded-xl border border-slate-700 text-sm w-full" placeholder="Email">
            <input type="text" name="whatsapp" id="edit_whatsapp" class="p-3 rounded-xl border border-slate-700 text-sm w-full" placeholder="WhatsApp">
            <input type="text" name="codigo_indicacao" id="edit_codigo" class="p-3 rounded-xl border border-slate-700 text-sm w-full" placeholder="Código Indicação">
            <select name="nivel" id="edit_nivel" class="p-3 rounded-xl border border-slate-700 text-sm w-full">
                <option value="motorista">Motorista</option>
                <option value="patrao">Patrão</option>
            </select>
            <div class="flex gap-2 mt-4">
                <button type="submit" name="editar_usuario" class="flex-1 bg-blue-600 text-white font-black py-3 rounded-xl uppercase text-xs">Salvar</button>
                <button type="button" onclick="this.closest('dialog').close()" class="bg-slate-800 px-6 py-3 rounded-xl font-black uppercase text-xs">Fechar</button>
            </div>
        </form>
    </dialog>

    <dialog id="modal_admin" class="glass rounded-[32px] p-8 text-slate-100 w-full max-w-md">
        <h3 class="text-xl font-black italic uppercase text-orange-500 mb-6">Novo Admin</h3>
        <form method="POST" class="flex flex-col gap-4">
            <input type="text" name="nome" placeholder="Nome" class="p-3 rounded-xl text-sm w-full" required>
            <input type="email" name="email" placeholder="E-mail" class="p-3 rounded-xl text-sm w-full" required>
            <input type="text" name="whatsapp" placeholder="WhatsApp" class="p-3 rounded-xl text-sm w-full">
            <input type="password" name="senha" placeholder="Senha" class="p-3 rounded-xl text-sm w-full" required>
            <button type="submit" name="add_admin" class="bg-orange-500 text-slate-950 font-black py-3 rounded-xl uppercase text-xs">Cadastrar</button>
        </form>
    </dialog>

    <script>
        function abrirEdicao(user) {
            document.getElementById('edit_id').value = user.id;
            document.getElementById('edit_nome').value = user.nome;
            document.getElementById('edit_email').value = user.email;
            document.getElementById('edit_whatsapp').value = user.whatsapp;
            document.getElementById('edit_codigo').value = user.codigo_indicacao;
            document.getElementById('edit_nivel').value = user.nivel;
            document.getElementById('modal_editar').showModal();
        }
        function confirmarExclusao(id, nome) {
            if (confirm("Deseja realmente excluir " + nome + "?")) {
                window.location.href = "admin.php?excluir_id=" + id;
            }
        }
    </script>
</body>
</html>