<?php
session_start();
require_once 'config.php';

$acao = $_POST['acao'] ?? '';
$referencia = basename($_SERVER['HTTP_REFERER'] ?? '');

// --- LÓGICA DE CADASTRO ---
if ($acao == 'cadastro') {
    $nome = $_POST['nome'];
    $whatsapp = $_POST['whatsapp'];
    $email = $_POST['email'];
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
    $tipo_motorista = $_POST['tipo_motorista'] ?? 'autonomo';
    $codigo_empresa_input = $_POST['codigo_empresa'] ?? null;
    $ref_by = $_POST['ref_by'] ?? null;
    
    // Tratamento do CPF (PIX)
    $pix_cpf = preg_replace('/[^0-9]/', '', $_POST['pix'] ?? '');

    // 1. Validação de E-mail duplicado
    $checkEmail = $pdo->prepare("SELECT id FROM usuarios WHERE email = ?");
    $checkEmail->execute([$email]);
    if ($checkEmail->rowCount() > 0) {
        header("Location: frete.php?error=Este e-mail já está cadastrado");
        exit();
    }

    // 2. Lógica para Funcionário vs Autônomo
    if ($tipo_motorista === 'funcionario') {
        // Verifica se a empresa existe e se tem vaga
        $stmtPatrao = $pdo->prepare("SELECT id, limite_motoristas FROM usuarios WHERE codigo_empresa = ? AND nivel = 'patrao'");
        $stmtPatrao->execute([$codigo_empresa_input]);
        $patrao = $stmtPatrao->fetch();

        if (!$patrao) {
            header("Location: frete.php?error=Codigo_da_empresa_invalido");
            exit();
        }

        // Conta funcionários atuais
        $stmtContar = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE codigo_empresa = ? AND tipo_motorista = 'funcionario'");
        $stmtContar->execute([$codigo_empresa_input]);
        $total_atual = $stmtContar->fetchColumn();

        $limite = $patrao['limite_motoristas'] ?: 5; // Padrão 5 se não definido

        if ($total_atual >= $limite) {
            header("Location: frete.php?error=Limite_da_empresa_atingido");
            exit();
        }
        $codigo_vincular = $codigo_empresa_input;
    } else {
        // Autônomo gera seu próprio código (caso queira ser patrão no futuro)
        $codigo_vincular = strtoupper(substr(uniqid(), -6));
    }

    // Gerar código de indicação para o novo usuário
    $codigo_indicacao = strtoupper(substr(md5(uniqid()), 0, 8));

    try {
        $sql = "INSERT INTO usuarios (nome, whatsapp, email, pix, senha, nivel, tipo_motorista, codigo_empresa, codigo_indicacao, indicado_por, data_cadastro, status) 
                VALUES (?, ?, ?, ?, ?, 'motorista', ?, ?, ?, ?, NOW(), 'ativo')";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$nome, $whatsapp, $email, $pix_cpf, $senha, $tipo_motorista, $codigo_vincular, $codigo_indicacao, $ref_by]);

        // Login automático após cadastro
        $_SESSION['usuario_id'] = $pdo->lastInsertId();
        $_SESSION['nome'] = $nome;
        $_SESSION['nivel'] = 'motorista';
        $_SESSION['codigo_empresa'] = $codigo_vincular;

        header("Location: painel.php");
        exit();
    } catch (PDOException $e) {
        header("Location: frete.php?error=Erro ao cadastrar: " . $e->getMessage());
        exit();
    }
}

// --- LÓGICA DE LOGIN ---
if ($acao == 'login') {
    $email = $_POST['email'];
    $senha = $_POST['senha'];

    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($senha, $user['senha'])) {
        
        // TRAVA DE SEGURANÇA: Bloqueia Admin e Patrão na frete.php
        if ($referencia == 'frete.php' || $referencia == 'fretes.php') {
            if ($user['nivel'] === 'admin') {
                header("Location: login_admin.php?error=Use o acesso administrativo");
                exit();
            }
            if ($user['nivel'] === 'patrao') {
                header("Location: login_patrao.php?error=Use o portal do gestor");
                exit();
            }
        }

        // TRAVA INVERSA: Motorista não entra no portal do patrão
        if ($referencia == 'login_patrao.php' && $user['nivel'] === 'motorista') {
             header("Location: frete.php?error=Acesso exclusivo para gestores");
             exit();
        }

        // Autoriza Sessão
        $_SESSION['usuario_id'] = $user['id'];
        $_SESSION['nome'] = $user['nome'];
        $_SESSION['nivel'] = $user['nivel'];
        $_SESSION['codigo_empresa'] = $user['codigo_empresa'];

        // Redirecionamento por Nível
        if ($user['nivel'] === 'admin') {
            header("Location: admin.php");
        } elseif ($user['nivel'] === 'patrao') {
            header("Location: painel_patrao.php");
        } else {
            header("Location: painel.php");
        }
        exit();

    } else {
        header("Location: " . $_SERVER['HTTP_REFERER'] . "?error=login_invalido");
        exit();
    }
}