-- Tabela de Usuários
CREATE TABLE usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100),
    email VARCHAR(100) UNIQUE,
    senha VARCHAR(255),
    whatsapp VARCHAR(20),
    status ENUM('pendente', 'ativo', 'bloqueado') DEFAULT 'pendente',
    nivel ENUM('motorista', 'admin') DEFAULT 'motorista',
    data_cadastro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de Fretes
CREATE TABLE fretes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT,
    placa VARCHAR(10),
    data_frete DATE,
    hora_inicio TIME,
    origem VARCHAR(100),
    destino VARCHAR(100),
    valor_ton DECIMAL(10,2),
    total_ton DECIMAL(10,3),
    total_geral DECIMAL(10,2),
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
);