<?php
session_start();
require_once 'config.php';
if (!isset($_SESSION['usuario_id'])) { header("Location: index.php"); exit(); }

$usuario_id = $_SESSION['usuario_id'];
$codigo_empresa = $_SESSION['codigo_empresa'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $tipo = $_POST['tipo'];
    $valor = $_POST['valor'];
    $data = $_POST['data'];
    $km = $_POST['km'] ?? 0;
    $litros = $_POST['litros'] ?? 0;
    $preco_litro = $_POST['preco_litro'] ?? 0;
    $desc = $_POST['descricao'] ?? '';

    $stmt = $pdo->prepare("INSERT INTO despesas (codigo_empresa, usuario_id, tipo_despesa, km_atual, litros, preco_litro, valor_total, descricao_geral, data_despesa) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$codigo_empresa, $usuario_id, $tipo, $km, $litros, $preco_litro, $valor, $desc, $data]);
    $sucesso = true;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lançar Despesa - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input, select { background: #0f172a !important; border: 1px solid #1e293b !important; color: white !important; }
    </style>
</head>
<body class="p-4 pb-20">
    <header class="mb-6 flex justify-between items-center max-w-md mx-auto">
        <h1 class="text-orange-500 font-black italic">ROTA PRIME</h1>
        <a href="painel.php" class="text-[10px] font-bold uppercase text-slate-400">Voltar</a>
    </header>

    <main class="max-w-md mx-auto">
        <section class="glass p-6 rounded-[35px]">
            <h2 class="text-sm font-black uppercase italic mb-6 text-center text-orange-500">Novo Lançamento</h2>
            
            <?php if(isset($sucesso)) echo "<p class='bg-green-500/20 text-green-500 p-3 rounded-xl text-[10px] font-bold mb-4 text-center'>Lançado com sucesso!</p>"; ?>

            <form method="POST" class="space-y-4">
                <div>
                    <label class="text-[9px] font-black uppercase text-slate-500 ml-2">Tipo</label>
                    <select name="tipo" id="tipo" required class="w-full p-4 rounded-2xl text-xs font-bold" onchange="toggleCampos(this.value)">
                        <option value="Abastecimento">Abastecimento (Diesel)</option>
                        <option value="Geral">Outras Despesas</option>
                    </select>
                </div>

                <div id="campos_abastecimento" class="space-y-4">
                    <div class="grid grid-cols-2 gap-2">
                        <div>
                            <label class="text-[9px] font-black uppercase text-slate-500 ml-2">KM Atual</label>
                            <input type="number" name="km" class="w-full p-4 rounded-2xl text-xs font-bold" placeholder="00000">
                        </div>
                        <div>
                            <label class="text-[9px] font-black uppercase text-slate-500 ml-2">Litros</label>
                            <input type="number" step="0.01" name="litros" id="litros" class="w-full p-4 rounded-2xl text-xs font-bold" placeholder="0.00">
                        </div>
                    </div>
                    <div>
                        <label class="text-[9px] font-black uppercase text-slate-500 ml-2">Preço por Litro (R$)</label>
                        <input type="number" step="0.001" name="preco_litro" id="preco_litro" class="w-full p-4 rounded-2xl text-xs font-bold border-orange-500/50" placeholder="0.000">
                    </div>
                </div>

                <div id="campo_descricao" class="hidden">
                    <label class="text-[9px] font-black uppercase text-slate-500 ml-2">Descrição</label>
                    <input type="text" name="descricao" class="w-full p-4 rounded-2xl text-xs font-bold" placeholder="Ex: Refeição, Peças, Borracharia">
                </div>

                <div class="grid grid-cols-2 gap-2">
                    <div>
                        <label class="text-[9px] font-black uppercase text-slate-500 ml-2">Valor Total</label>
                        <input type="number" step="0.01" name="valor" id="valor_total" required class="w-full p-4 rounded-2xl text-xs font-bold text-orange-500" placeholder="0,00">
                    </div>
                    <div>
                        <label class="text-[9px] font-black uppercase text-slate-500 ml-2">Data</label>
                        <input type="date" name="data" value="<?php echo date('Y-m-d'); ?>" required class="w-full p-4 rounded-2xl text-xs font-bold">
                    </div>
                </div>

                <button type="submit" class="w-full bg-orange-500 text-slate-950 font-black p-4 rounded-2xl text-xs uppercase italic mt-4 shadow-lg shadow-orange-500/20">Confirmar</button>
            </form>
        </section>
    </main>

    <script>
        function toggleCampos(tipo) {
            document.getElementById('campos_abastecimento').classList.toggle('hidden', tipo !== 'Abastecimento');
            document.getElementById('campo_descricao').classList.toggle('hidden', tipo === 'Abastecimento');
        }

        const litrosInput = document.getElementById('litros');
        const precoInput = document.getElementById('preco_litro');
        const totalInput = document.getElementById('valor_total');

        function calcular() {
            if(litrosInput.value && precoInput.value) {
                totalInput.value = (parseFloat(litrosInput.value) * parseFloat(precoInput.value)).toFixed(2);
            }
        }
        litrosInput.addEventListener('input', calcular);
        precoInput.addEventListener('input', calcular);
    </script>
</body>
</html>