<?php
session_start();
require_once 'config.php';

if (!isset($_SESSION['usuario_id']) || !isset($_GET['id'])) {
    header("Location: painel.php");
    exit();
}

$stmt = $pdo->prepare("SELECT * FROM fretes WHERE id = ? AND usuario_id = ?");
$stmt->execute([$_GET['id'], $_SESSION['usuario_id']]);
$frete = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$frete) { die("Frete não encontrado."); }
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>ROTA PRIME - Editar Frete</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.4); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        .input-dark { 
            background: #1e293b !important; 
            border: 1px solid #334155 !important; 
            color: white !important; 
        }
        .input-dark:focus { border-color: #f59e0b !important; }
    </style>
</head>
<body class="pb-24">

    <div class="p-8 text-center">
        <div class="inline-block bg-orange-500 text-slate-900 px-5 py-1 skew-x-[-15deg] font-black text-2xl italic mb-1">
            ROTA PRIME
        </div>
        <p class="text-slate-500 text-[10px] uppercase tracking-[0.4em] font-bold">Editar Lançamento</p>
    </div>

    <div class="max-w-md mx-auto px-4">
        
        <div class="glass p-6 rounded-[35px] shadow-2xl">
            <h2 class="text-white text-lg font-black italic mb-6 uppercase tracking-tighter flex items-center gap-2">
                <i class="fa-solid fa-pen-to-square text-orange-500"></i>
                Ajustar Dados
            </h2>

            <form action="painel.php" method="POST" class="space-y-4">
                <input type="hidden" name="acao" value="atualizar">
                <input type="hidden" name="id" value="<?php echo $frete['id']; ?>">
                
                <div class="grid grid-cols-2 gap-3">
                    <div class="space-y-1">
                        <label class="text-[10px] font-bold text-slate-400 uppercase ml-2">Data</label>
                        <input type="date" name="data_frete" required value="<?php echo $frete['data_frete']; ?>"
                               class="input-dark w-full p-4 rounded-2xl outline-none text-sm">
                    </div>
                    <div class="space-y-1">
                        <label class="text-[10px] font-bold text-slate-400 uppercase ml-2">Hora de Saída</label>
                        <input type="time" name="hora_inicio" required value="<?php echo date('H:i', strtotime($frete['hora_inicio'])); ?>"
                               class="input-dark w-full p-4 rounded-2xl outline-none text-sm">
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-3">
                    <div class="space-y-1">
                        <label class="text-[10px] font-bold text-slate-400 uppercase ml-2">Placa</label>
                        <input type="text" name="placa" value="<?php echo $frete['placa']; ?>" required
                               class="input-dark w-full p-4 rounded-2xl outline-none text-sm uppercase">
                    </div>
                    <div class="space-y-1">
                        <label class="text-[10px] font-bold text-orange-400 uppercase ml-2">KM Inicial</label>
                        <input type="number" name="km_inicial" value="<?php echo $frete['km_inicial']; ?>" required
                               class="input-dark w-full p-4 rounded-2xl outline-none text-sm">
                    </div>
                </div>

                <div class="space-y-1">
                    <label class="text-[10px] font-bold text-slate-400 uppercase ml-2">Cidade Origem</label>
                    <input type="text" name="origem" value="<?php echo $frete['origem']; ?>" required
                           class="input-dark w-full p-4 rounded-2xl outline-none text-sm">
                </div>

                <div class="space-y-1">
                    <label class="text-[10px] font-bold text-slate-400 uppercase ml-2">Cidade Destino</label>
                    <input type="text" name="destino" value="<?php echo $frete['destino']; ?>" required
                           class="input-dark w-full p-4 rounded-2xl outline-none text-sm">
                </div>

                <div class="grid grid-cols-2 gap-3">
                    <div class="space-y-1">
                        <label class="text-[10px] font-bold text-slate-400 uppercase ml-2">Peso (Ton)</label>
                        <input type="number" step="0.001" name="total_ton" id="peso" value="<?php echo $frete['total_ton']; ?>" required
                               class="input-dark w-full p-4 rounded-2xl outline-none text-sm">
                    </div>
                    <div class="space-y-1">
                        <label class="text-[10px] font-bold text-slate-400 uppercase ml-2">R$ Frete (Ton)</label>
                        <input type="number" step="0.01" name="valor_ton" id="valor" value="<?php echo $frete['valor_ton']; ?>" required
                               class="input-dark w-full p-4 rounded-2xl outline-none text-sm">
                    </div>
                </div>

                <div class="bg-slate-950/50 p-4 rounded-2xl border border-dashed border-slate-700 mt-2 text-center">
                    <p class="text-[9px] font-bold text-slate-500 uppercase mb-1">Valor Total Bruto</p>
                    <div class="text-xl font-black text-orange-500 italic" id="display-total">R$ 0,00</div>
                </div>

                <button type="submit" class="w-full bg-orange-500 text-slate-950 font-black py-5 rounded-2xl uppercase italic tracking-tighter shadow-lg shadow-orange-900/20 flex items-center justify-center gap-2 active:scale-95 transition-all">
                    <i class="fa-solid fa-floppy-disk"></i>
                    Salvar Alterações
                </button>

            </form>
        </div>

        <a href="painel.php" class="block text-center mt-6 text-slate-500 text-[10px] font-black uppercase tracking-[0.2em] italic hover:text-white transition-all">
            <i class="fa-solid fa-xmark mr-1"></i> Descartar Alterações
        </a>

    </div>

    <script>
        const pesoInput = document.getElementById('peso');
        const valorInput = document.getElementById('valor');
        const displayTotal = document.getElementById('display-total');

        function calcular() {
            const peso = parseFloat(pesoInput.value) || 0;
            const valor = parseFloat(valorInput.value) || 0;
            const total = peso * valor;
            displayTotal.innerText = total.toLocaleString('pt-br', {style: 'currency', currency: 'BRL'});
        }

        // Calcular ao carregar a página
        window.onload = calcular;
        
        pesoInput.addEventListener('input', calcular);
        valorInput.addEventListener('input', calcular);
    </script>

</body>
</html>