<?php
session_start();
require_once 'config.php';

// --- LÓGICA DE INDICAÇÃO ---
$nome_indicador = "";
if (isset($_GET['ref'])) {
    $ref = $_GET['ref'];
    $stmt = $pdo->prepare("SELECT nome FROM usuarios WHERE codigo_indicacao = ?");
    $stmt->execute([$ref]);
    $indicador = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($indicador) {
        $nome_indicador = $indicador['nome'];
        setcookie("indicado_por", $nome_indicador, time() + 86400, "/");
        setcookie("ref_codigo", $ref, time() + 86400, "/");
    }
} elseif (isset($_COOKIE['indicado_por'])) {
    $nome_indicador = $_COOKIE['indicado_por'];
}

if (isset($_SESSION['usuario_id'])) {
    header("Location: " . ($_SESSION['nivel'] == 'admin' ? "admin.php" : "painel.php"));
    exit();
}
$erro = $_GET['error'] ?? '';
$comissao_exibir = $pdo->query("SELECT comissao_porcentagem FROM configuracoes WHERE id = 1")->fetchColumn() ?: 10;
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ROTA PRIME - O Comando do seu Lucro</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700;900&display=swap" rel="stylesheet">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; scroll-behavior: smooth; }
        .hero-bg {
            background: linear-gradient(to bottom, rgba(2, 6, 23, 0.5), rgba(2, 6, 23, 0.95)), 
                        url('https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?auto=format&fit=crop&w=1920&q=80');
            background-size: cover; background-position: center; background-attachment: fixed;
        }
        .prime-gradient { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); }
        .text-gradient { background: linear-gradient(to right, #f59e0b, #fbbf24); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }
        .card-blur { background: rgba(15, 23, 42, 0.8); backdrop-filter: blur(12px); border: 1px solid rgba(255,255,255,0.05); transition: 0.3s; }
        .card-blur:hover { border-color: #f59e0b; transform: translateY(-5px); }
        input, select { background: #0f172a !important; border: 1px solid #1e293b !important; color: white !important; outline: none; }
        input:focus { border-color: #f59e0b !important; }
        .welcome-bar { animation: slideDown 0.5s ease-out; }
        @keyframes slideDown { from { transform: translateY(-100%); } to { transform: translateY(0); } }
    </style>
</head>
<body class="min-h-screen flex flex-col">

    <?php if ($nome_indicador): ?>
    <div class="welcome-bar fixed top-0 left-0 w-full z-[100] bg-orange-500 text-slate-950 p-2.5 text-center font-black uppercase italic text-[10px] tracking-[0.2em] shadow-xl">
        <i class="fa-solid fa-crown mr-2"></i> Você foi convidado por: <?php echo explode(' ', trim($nome_indicador))[0]; ?>
    </div>
    <?php endif; ?>

    <header class="fixed top-0 left-0 w-full z-50 p-4 md:px-10 flex justify-between items-center backdrop-blur-md bg-slate-950/40 border-b border-white/5 <?php echo $nome_indicador ? 'mt-9' : ''; ?>">
        <div class="font-black italic text-orange-500 tracking-tighter text-2xl">ROTA PRIME</div>
        <div class="flex items-center gap-2 md:gap-4">
            <a href="https://ofertaexcelente.com.br/meus/rota_prime_1.0.zip" class="bg-emerald-600 hover:bg-emerald-500 text-white px-4 py-2 rounded-xl text-[10px] font-black uppercase tracking-widest transition-all flex items-center gap-2 shadow-lg shadow-emerald-900/20">
                <i class="fas fa-download"></i> <span class="hidden md:inline">Instalar</span> APK
            </a>
            <a href="#acesso" onclick="toggleAuth('login')" class="bg-white/10 hover:bg-orange-500 text-white hover:text-slate-900 px-4 py-2 rounded-xl text-[10px] font-black uppercase tracking-widest transition-all border border-white/10">Painel</a>
        </div>
    </header>

    <section class="hero-bg min-h-screen flex flex-col items-center justify-center p-6 pt-32 text-center relative">
        <div class="z-10 max-w-5xl w-full">
            <div class="inline-block bg-orange-500 text-slate-950 px-4 py-1 skew-x-[-15deg] font-black italic text-xs uppercase mb-6 shadow-lg">Controle de Fretes Profissional</div>
            <h1 class="text-5xl md:text-8xl font-black mb-8 leading-[0.9] italic uppercase">O COMANDO DO SEU <br><span class="text-gradient">LUCRO NA ESTRADA</span></h1>
            <div class="max-w-3xl mx-auto mb-10 rounded-[40px] border-[6px] border-white/5 shadow-2xl overflow-hidden bg-black/40 backdrop-blur-sm">
                <video controls class="w-full aspect-video"><source src="rota_praime.mp4" type="video/mp4"></video>
            </div>
            <div class="flex flex-col md:flex-row gap-4 justify-center mb-16">
                <a href="#acesso" onclick="toggleAuth('cad')" class="prime-gradient text-slate-950 font-black px-12 py-5 rounded-2xl text-lg hover:scale-105 transition-all shadow-2xl shadow-orange-500/40 uppercase italic">Testar Grátis 7 Dias</a>
                <a href="https://ofertaexcelente.com.br/meus/rota_prime_1.0.zip" class="bg-emerald-600 text-white font-black px-12 py-5 rounded-2xl text-lg hover:scale-105 transition-all shadow-2xl shadow-emerald-500/20 uppercase italic flex items-center justify-center gap-3">
                    <i class="fas fa-mobile-alt"></i> Baixar App APK
                </a>
            </div>
        </div>
    </section>

    <section id="beneficios" class="py-24 bg-slate-950">
        <div class="max-w-6xl mx-auto px-6">
            <h2 class="text-center text-orange-500 font-black uppercase italic tracking-widest mb-16">O que você ganha no Rota Prime</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="card-blur p-8 rounded-[32px] border-b-4 border-orange-500">
                    <div class="w-12 h-12 bg-orange-500/10 flex items-center justify-center rounded-2xl mb-6 text-orange-500 text-2xl"><i class="fas fa-calculator"></i></div>
                    <h3 class="text-xl font-black uppercase italic mb-4">Cálculo Líquido</h3>
                    <p class="text-gray-400 text-sm leading-relaxed">Chega de surpresas. Saiba exatamente quanto sobra no seu bolso antes de fechar o frete.</p>
                </div>
                <div class="card-blur p-8 rounded-[32px] border-b-4 border-orange-500">
                    <div class="w-12 h-12 bg-orange-500/10 flex items-center justify-center rounded-2xl mb-6 text-orange-500 text-2xl"><i class="fas fa-file-invoice-dollar"></i></div>
                    <h3 class="text-xl font-black uppercase italic mb-4">Relatórios PDF</h3>
                    <p class="text-gray-400 text-sm leading-relaxed">Envie comprovantes profissionais via WhatsApp com 1 clique. Organização nível Prime.</p>
                </div>
                <div class="card-blur p-8 rounded-[32px] border-b-4 border-orange-500">
                    <div class="w-12 h-12 bg-orange-500/10 flex items-center justify-center rounded-2xl mb-6 text-orange-500 text-2xl"><i class="fas fa-cloud-upload-alt"></i></div>
                    <h3 class="text-xl font-black uppercase italic mb-4">Nuvem Segura</h3>
                    <p class="text-gray-400 text-sm leading-relaxed">Trocou de celular? Seus dados estão salvos. Acesse de qualquer lugar, a qualquer hora.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="py-24 bg-slate-900 border-y border-white/5">
        <div class="max-w-6xl mx-auto px-6">
            <div class="text-center mb-16">
                <span class="text-orange-500 font-black uppercase tracking-widest text-xs italic">Soluções Corporativas</span>
                <h2 class="text-4xl md:text-6xl font-black mt-4 italic uppercase">Sua Frota em <span class="text-gradient">Tempo Real</span></h2>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <div class="bg-slate-950/50 p-6 rounded-3xl border border-white/5">
                    <i class="fas fa-users-cog text-orange-500 text-3xl mb-4"></i>
                    <h4 class="font-black uppercase italic text-sm mb-2">Controle de Motoristas</h4>
                    <p class="text-slate-500 text-xs">Acompanhe todos os seus motoristas em um único painel centralizado.</p>
                </div>
                <div class="bg-slate-950/50 p-6 rounded-3xl border border-white/5">
                    <i class="fas fa-chart-line text-orange-500 text-3xl mb-4"></i>
                    <h4 class="font-black uppercase italic text-sm mb-2">Lucro Real da Empresa</h4>
                    <p class="text-slate-500 text-xs">Veja o faturamento bruto vs a comissão paga, garantindo sua margem de lucro.</p>
                </div>
                <div class="bg-slate-950/50 p-6 rounded-3xl border border-white/5">
                    <i class="fas fa-gas-pump text-orange-500 text-3xl mb-4"></i>
                    <h4 class="font-black uppercase italic text-sm mb-2">Gestão de Custos</h4>
                    <p class="text-slate-500 text-xs">Lançamento de despesas e manutenção por veículo para evitar desperdícios.</p>
                </div>
                <div class="bg-slate-950/50 p-6 rounded-3xl border border-white/5">
                    <i class="fas fa-shield-alt text-orange-500 text-3xl mb-4"></i>
                    <h4 class="font-black uppercase italic text-sm mb-2">Segurança de Dados</h4>
                    <p class="text-slate-500 text-xs">Controle quem pode acessar as informações sensíveis da sua transportadora.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="py-24 bg-slate-950 border-y border-white/5">
        <div class="max-w-6xl mx-auto px-6 flex flex-col md:flex-row items-center gap-12">
            <div class="flex-1">
                <span class="text-orange-500 font-black uppercase tracking-widest text-xs italic">Programa de Parceria</span>
                <h2 class="text-4xl md:text-6xl font-black mt-4 mb-6 italic uppercase leading-tight">INDIQUE E <br><span class="text-gradient">RECEBA BÔNUS</span></h2>
                <p class="text-gray-400 text-lg leading-relaxed">Ganhe <strong><?php echo $comissao_exibir; ?>% de bônus</strong> por cada colega que assinar através do seu link. Dinheiro creditado direto no seu painel!</p>
            </div>
            <div class="bg-orange-500 p-10 rounded-[40px] shadow-2xl shadow-orange-500/20 rotate-2">
                <p class="text-slate-950 font-black uppercase italic text-xs mb-2">Potencial de Ganho</p>
                <p class="text-5xl font-black text-slate-950 italic">PIX DIRETO</p>
                <p class="text-slate-900/70 text-xs mt-4 font-bold uppercase">Saques rápidos para parceiros ativos</p>
            </div>
        </div>
    </section>

    <section id="acesso" class="py-24 bg-slate-950">
        <div class="max-w-md mx-auto px-6">
            <div class="bg-slate-900 p-10 rounded-[45px] border border-white/10 shadow-2xl">
                <div class="flex gap-2 mb-8 bg-black/40 p-1.5 rounded-2xl">
                    <button onclick="toggleAuth('login')" id="btn-login" class="flex-1 py-4 rounded-xl prime-gradient text-slate-950 font-black text-xs uppercase italic transition-all">Entrar</button>
                    <button onclick="toggleAuth('cad')" id="btn-cad" class="flex-1 py-4 rounded-xl text-gray-500 font-black text-xs uppercase transition-all">Cadastrar</button>
                </div>

                <form id="form-login" action="auth.php" method="POST" class="space-y-4">
                    <input type="hidden" name="acao" value="login">
                    <input type="email" name="email" placeholder="Seu E-mail" required class="w-full p-4 rounded-2xl text-sm">
                    <input type="password" name="senha" placeholder="Sua Senha" required class="w-full p-4 rounded-2xl text-sm">
                    <button type="submit" class="w-full prime-gradient text-slate-950 font-black py-5 rounded-2xl uppercase italic tracking-tighter shadow-xl">Entrar no Comando</button>
                </form>

                <form id="form-cad" action="auth.php" method="POST" class="hidden space-y-4">
                    <input type="hidden" name="acao" value="cadastro">
                    <input type="hidden" name="ref_by" value="<?php echo $_COOKIE['ref_codigo'] ?? ($_GET['ref'] ?? ''); ?>">
                    
                    <input type="text" name="nome" placeholder="Nome Completo" required class="w-full p-4 rounded-2xl text-sm">
                    <input type="text" name="whatsapp" placeholder="WhatsApp" required class="w-full p-4 rounded-2xl text-sm">
                    <input type="email" name="email" placeholder="Seu E-mail" required class="w-full p-4 rounded-2xl text-sm">
                    <input type="text" name="pix" placeholder="Chave PIX CPF (Obrigatório) *" required class="w-full p-4 rounded-2xl text-sm border-emerald-500/30">

                    <select name="tipo_motorista" id="tipo_motorista" onchange="toggleEmpresaField()" class="w-full p-4 rounded-2xl text-sm bg-slate-800 text-white border border-white/10 outline-none">
                        <option value="autonomo">Motorista Autônomo</option>
                        <option value="funcionario">Funcionário de Empresa (Frota)</option>
                    </select>

                    <div id="div_codigo_empresa" class="hidden">
                        <input type="text" name="codigo_empresa" id="input_codigo_empresa" placeholder="Código da Empresa (Peça ao seu Patrão)" class="w-full p-4 rounded-2xl text-sm border-orange-500/50">
                    </div>

                    <input type="password" name="senha" placeholder="Crie uma Senha" required class="w-full p-4 rounded-2xl text-sm">
                    <button type="submit" class="w-full prime-gradient text-slate-950 font-black py-5 rounded-2xl uppercase italic tracking-tighter">Criar minha Conta</button>
                </form>
            </div>
        </div>
    </section>

    <footer class="bg-black py-16 px-6 text-center border-t border-white/5">
        <div class="max-w-4xl mx-auto">
            <div class="text-[9px] text-gray-700 uppercase tracking-[0.3em] font-bold space-y-4">
                <p>Este site não faz parte do Google ou Facebook. ROTA PRIME é uma ferramenta independente.</p>
                <div class="flex justify-center gap-6 py-4">
                    <a href="privacidade.php" class="hover:text-orange-500">Privacidade</a>
                    <a href="termos.php" class="hover:text-orange-500">Termos</a>
                </div>
                <p>ROTA PRIME &copy; <?php echo date('Y'); ?> • Gestão para Profissionais do Volante</p>
            </div>
        </div>
    </footer>

    <script>
        function toggleAuth(modo) {
            const fL = document.getElementById('form-login'), fC = document.getElementById('form-cad'), bL = document.getElementById('btn-login'), bC = document.getElementById('btn-cad');
            if (modo === 'login') {
                fL.classList.remove('hidden'); fC.classList.add('hidden');
                bL.className = "flex-1 py-4 rounded-xl prime-gradient text-slate-950 font-black text-xs uppercase italic transition-all";
                bC.className = "flex-1 py-4 rounded-xl text-gray-500 font-black text-xs uppercase transition-all";
            } else {
                fC.classList.remove('hidden'); fL.classList.add('hidden');
                bC.className = "flex-1 py-4 rounded-xl prime-gradient text-slate-950 font-black text-xs uppercase italic transition-all";
                bL.className = "flex-1 py-4 rounded-xl text-gray-500 font-black text-xs uppercase transition-all";
            }
        }

        // Função para mostrar/esconder código da empresa
        function toggleEmpresaField() {
            const tipo = document.getElementById('tipo_motorista').value;
            const div = document.getElementById('div_codigo_empresa');
            const input = document.getElementById('input_codigo_empresa');
            if(tipo === 'funcionario') {
                div.classList.remove('hidden');
                input.required = true;
            } else {
                div.classList.add('hidden');
                input.required = false;
            }
        }

        window.onload = function() {
            if (window.location.search.includes('ref=') || window.location.search.includes('error=')) {
                document.getElementById('acesso').scrollIntoView();
                if (window.location.search.includes('ref=')) toggleAuth('cad');
            }
        }
    </script>
</body>
</html>