<?php
session_start();
require_once 'config.php';
date_default_timezone_set('America/Sao_Paulo');

if (!isset($_SESSION['usuario_id'])) {
    die("Acesso negado. Faça login.");
}

$usuario_id = $_SESSION['usuario_id'];
$nome_motorista = $_SESSION['usuario_nome'] ?? 'Motorista';

// Filtro de data (pega os mesmos filtros do painel)
$data_inicio = $_GET['f_inicio'] ?? date('Y-m-01');
$data_fim = $_GET['f_fim'] ?? date('Y-m-t');

// Busca os fretes com todos os novos campos
$stmt = $pdo->prepare("SELECT * FROM fretes WHERE usuario_id = ? AND data_frete BETWEEN ? AND ? ORDER BY data_frete DESC, hora_inicio DESC");
$stmt->execute([$usuario_id, $data_inicio, $data_fim]);
$fretes = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total_acumulado = 0;
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Relatório Rota Prime - <?php echo $nome_motorista; ?></title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; padding: 30px; color: #1a1a1a; background-color: #fff; line-height: 1.4; }
        .header-print { border-bottom: 4px solid #f59e0b; padding-bottom: 15px; margin-bottom: 25px; display: flex; justify-content: space-between; align-items: flex-end; }
        .btn-imprimir { background: #f59e0b; color: #000; padding: 12px 25px; border: none; border-radius: 8px; font-weight: 900; cursor: pointer; text-transform: uppercase; font-size: 14px; margin-bottom: 20px; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 12px; }
        th { background-color: #f8f9fa; color: #444; text-transform: uppercase; font-size: 10px; letter-spacing: 1px; border: 1px solid #dee2e6; padding: 12px 8px; }
        td { border: 1px solid #dee2e6; padding: 10px 8px; text-align: left; }
        
        .placa-txt { background: #f1f5f9; padding: 2px 6px; border-radius: 4px; font-weight: bold; border: 1px solid #cbd5e1; font-family: monospace; display: inline-block; margin-top: 4px; font-size: 11px; }
        .km-badge { color: #64748b; font-family: monospace; }
        
        .total-box { background: #020617; color: #fff; padding: 15px 25px; border-radius: 12px; text-align: right; min-width: 200px; }
        .total-label { font-size: 10px; text-transform: uppercase; color: #f59e0b; font-weight: bold; display: block; }
        .total-valor { font-size: 22px; font-weight: 900; }
        
        .footer { margin-top: 40px; display: flex; justify-content: space-between; align-items: center; border-top: 1px solid #eee; pt: 10px; }

        @media print { 
            .btn-imprimir { display: none; } 
            body { padding: 0; }
            .total-box { border: 2px solid #000; color: #000; background: #fff; }
        }
    </style>
</head>
<body>

    <button class="btn-imprimir" onclick="window.print()">
        GERAR PDF / IMPRIMIR RELATÓRIO
    </button>

    <div class="header-print">
        <div>
            <h1 style="margin:0; font-style: italic; font-weight: 900; color: #f59e0b; letter-spacing: -1px;">ROTA PRIME</h1>
            <p style="margin:5px 0; font-size: 14px; font-weight: bold; color: #444;">Relatório de Prestação de Contas</p>
        </div>
        <div style="text-align: right;">
            <p style="margin:0; font-weight: 800; text-transform: uppercase;"><?php echo $nome_motorista; ?></p>
            <p style="margin:0; font-size: 11px; color: #666;">Período: <?php echo date('d/m/Y', strtotime($data_inicio)); ?> — <?php echo date('d/m/Y', strtotime($data_fim)); ?></p>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th width="15%">Data/Hora</th>
                <th width="35%">Trajeto e Placa</th>
                <th width="12%">KM Inicial</th>
                <th width="12%">Peso (Ton)</th>
                <th width="13%">Valor/Ton</th>
                <th width="13%">Total Líquido</th>
            </tr>
        </thead>
        <tbody>
            <?php if(count($fretes) > 0): ?>
                <?php foreach ($fretes as $f): 
                    $total_acumulado += $f['total_geral'];
                ?>
                <tr>
                    <td>
                        <strong><?php echo date('d/m/Y', strtotime($f['data_frete'])); ?></strong><br>
                        <span style="color: #666;"><?php echo date('H:i', strtotime($f['hora_inicio'])); ?>h</span>
                    </td>
                    
                    <td>
                        <div style="font-weight: bold;"><?php echo $f['origem']; ?> <span style="color: #f59e0b;">➔</span> <?php echo $f['destino']; ?></div>
                        <div class="placa-txt"><?php echo strtoupper($f['placa']); ?></div>
                    </td>
                    
                    <td class="km-badge"><?php echo number_format($f['km_inicial'], 0, ',', '.'); ?></td>
                    
                    <td><?php echo number_format($f['total_ton'], 3, ',', '.'); ?> t</td>
                    
                    <td>R$ <?php echo number_format($f['valor_ton'], 2, ',', '.'); ?></td>
                    
                    <td style="font-weight: 900;">R$ <?php echo number_format($f['total_geral'], 2, ',', '.'); ?></td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" style="text-align:center; padding: 30px; color: #999;">Nenhuma viagem encontrada neste período.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <div style="font-size: 10px; color: #999;">
            Documento gerado em <?php echo date('d/m/Y \à\s H:i'); ?>
        </div>
        <div class="total-box">
            <span class="total-label">Saldo Acumulado</span>
            <span class="total-valor">R$ <?php echo number_format($total_acumulado, 2, ',', '.'); ?></span>
        </div>
    </div>

</body>
</html>