<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once 'config.php';

if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] !== 'patrao') {
    header("Location: fretes.php"); exit();
}

$codigo_empresa = $_SESSION['codigo_empresa'];

// --- LÓGICA: SALVAR OU EDITAR ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['acao'])) {
    $origem = strtoupper(trim($_POST['origem']));
    $destino = strtoupper(trim($_POST['destino']));
    $preco = $_POST['preco'];
    $id_edit = !empty($_POST['id_edicao']) ? $_POST['id_edicao'] : null;

    if ($id_edit) {
        $stmt = $pdo->prepare("UPDATE precos_patrao SET origem = ?, destino = ?, preco_ton_bruto = ? WHERE id = ? AND codigo_empresa = ?");
        $stmt->execute([$origem, $destino, $preco, $id_edit, $codigo_empresa]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO precos_patrao (codigo_empresa, origem, destino, preco_ton_bruto) VALUES (?, ?, ?, ?)");
        $stmt->execute([$codigo_empresa, $origem, $destino, $preco]);
    }
    header("Location: gerenciar_precos.php"); exit();
}

// --- LÓGICA: EXCLUIR ---
if (isset($_GET['excluir'])) {
    $stmt = $pdo->prepare("DELETE FROM precos_patrao WHERE id = ? AND codigo_empresa = ?");
    $stmt->execute([(int)$_GET['excluir'], $codigo_empresa]);
    header("Location: gerenciar_precos.php"); exit();
}

// --- BUSCA TODAS AS ROTAS CADASTRADAS ---
$stmt = $pdo->prepare("SELECT * FROM precos_patrao WHERE codigo_empresa = ? ORDER BY origem ASC, destino ASC");
$stmt->execute([$codigo_empresa]);
$tabela_precos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tabela de Preços - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input { background: #0f172a !important; border: 1px solid #1e293b !important; color: white !important; outline: none; }
    </style>
</head>
<body class="pb-20">

    <header class="p-6 max-w-4xl mx-auto flex justify-between items-center">
        <a href="painel_patrao.php" class="text-slate-500 hover:text-white transition-all"><i class="fa-solid fa-arrow-left mr-2"></i> Voltar</a>
        <h1 class="text-orange-500 font-black italic text-xl uppercase">TABELA DE PREÇOS</h1>
        <div class="w-10"></div>
    </header>

    <main class="max-w-4xl mx-auto px-4">
        
        <section class="glass p-6 rounded-[35px] mb-8 border-orange-500/20">
            <form method="POST" id="formPreco" class="grid grid-cols-1 md:grid-cols-4 gap-3">
                <input type="hidden" name="acao" value="salvar">
                <input type="hidden" name="id_edicao" id="id_edicao">
                <input type="text" name="origem" id="in_origem" placeholder="Origem" required class="p-4 rounded-2xl text-xs uppercase font-bold">
                <input type="text" name="destino" id="in_destino" placeholder="Destino" required class="p-4 rounded-2xl text-xs uppercase font-bold">
                <input type="number" step="0.01" name="preco" id="in_preco" placeholder="Valor p/ Ton" required class="p-4 rounded-2xl text-xs font-bold">
                <button type="submit" id="btn_save" class="bg-orange-500 text-slate-950 font-black rounded-2xl text-[10px] uppercase italic">Salvar Rota</button>
            </form>
        </section>

        <div class="space-y-3">
            <h3 class="text-[10px] font-black uppercase text-slate-500 px-2 tracking-widest">Rotas e Preços Ativos</h3>
            <?php foreach($tabela_precos as $p): ?>
            <div class="glass p-4 rounded-3xl flex justify-between items-center border border-white/5 hover:border-orange-500/30 transition-all">
                <div>
                    <h4 class="font-black italic text-sm uppercase"><?php echo $p['origem']; ?> <span class="text-orange-500">→</span> <?php echo $p['destino']; ?></h4>
                    <p class="text-[10px] text-orange-500 font-black italic">R$ <?php echo number_format($p['preco_ton_bruto'], 2, ',', '.'); ?> <span class="text-slate-500 font-normal">/ Tonelada</span></p>
                </div>
                <div class="flex gap-4">
                    <button onclick="editar('<?php echo $p['id']; ?>','<?php echo $p['origem']; ?>','<?php echo $p['destino']; ?>','<?php echo $p['preco_ton_bruto']; ?>')" class="text-slate-400 hover:text-white"><i class="fa-solid fa-pen"></i></button>
                    <a href="?excluir=<?php echo $p['id']; ?>" onclick="return confirm('Excluir esta rota?')" class="text-slate-600 hover:text-red-500"><i class="fa-solid fa-trash"></i></a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </main>

    <script>
        function editar(id, ori, des, pre) {
            document.getElementById('id_edicao').value = id;
            document.getElementById('in_origem').value = ori;
            document.getElementById('in_destino').value = des;
            document.getElementById('in_preco').value = pre;
            document.getElementById('btn_save').innerText = "Atualizar Rota";
            document.getElementById('btn_save').className = "bg-blue-500 text-white font-black rounded-2xl text-[10px] uppercase italic";
            window.scrollTo({top: 0, behavior: 'smooth'});
        }
    </script>
</body>
</html>