<?php
session_start();
require_once 'config.php';
date_default_timezone_set('America/Sao_Paulo');

if (!isset($_SESSION['usuario_id'])) { die("Acesso negado."); }

$usuario_id = $_SESSION['usuario_id'];
$data_inicio = $_GET['f_inicio'] ?? date('Y-m-01');
$data_fim = $_GET['f_fim'] ?? date('Y-m-t');

// Busca os fretes com todos os detalhes
$stmt = $pdo->prepare("SELECT * FROM fretes WHERE usuario_id = ? AND data_frete BETWEEN ? AND ? ORDER BY data_frete DESC");
$stmt->execute([$usuario_id, $data_inicio, $data_fim]);
$fretes = $stmt->fetchAll(PDO::FETCH_ASSOC);
$total_periodo = array_sum(array_column($fretes, 'total_geral'));
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

    <style>
        body { background-color: #020617; }
        .pdf-page { background: white; color: black; padding: 30px; width: 100%; max-width: 800px; margin: 0 auto; font-family: sans-serif; }
        @media print { .no-print { display: none; } }
    </style>
</head>
<body class="p-2 sm:p-6">

    <div class="no-print max-w-2xl mx-auto mb-6 flex gap-3">
        <a href="painel.php" class="bg-slate-800 text-white px-5 py-4 rounded-2xl font-bold text-xs flex items-center shadow-lg">
            <i class="fa-solid fa-arrow-left mr-2"></i> VOLTAR
        </a>
        <button onclick="baixarRelatorioPDF()" id="btn-pdf" class="flex-1 bg-orange-500 text-slate-950 px-6 py-4 rounded-2xl font-black uppercase text-xs shadow-xl shadow-orange-500/30">
            <i class="fa-solid fa-file-pdf mr-2 text-lg"></i> BAIXAR RELATÓRIO PDF
        </button>
    </div>

    <div id="relatorio-conteudo" class="pdf-page shadow-2xl rounded-sm">
        <div style="border-bottom: 4px solid #ea580c; padding-bottom: 15px; margin-bottom: 25px; display: flex; justify-content: space-between; align-items: center;">
            <div>
                <h1 style="font-size: 32px; font-weight: 900; color: #ea580c; font-style: italic; margin: 0;">ROTA PRIME</h1>
                <p style="font-size: 10px; font-weight: bold; color: #64748b; text-transform: uppercase; margin: 0;">Controle Profissional de Fretes</p>
            </div>
            <div style="text-align: right; font-size: 10px; color: #94a3b8;">
                EMISSÃO: <?php echo date('d/m/Y H:i'); ?>
            </div>
        </div>

        <div style="margin-bottom: 25px; font-size: 13px; border-left: 4px solid #f1f5f9; padding-left: 15px;">
            <strong>Motorista:</strong> <?php echo $_SESSION['usuario_nome']; ?><br>
            <strong>Período:</strong> <?php echo date('d/m/Y', strtotime($data_inicio)); ?> a <?php echo date('d/m/Y', strtotime($data_fim)); ?>
        </div>

        <table style="width: 100%; border-collapse: collapse; font-size: 11px;">
            <thead>
                <tr style="background: #0f172a; color: white;">
                    <th style="padding: 12px; text-align: left; border: 1px solid #0f172a;">DATA/PLACA</th>
                    <th style="padding: 12px; text-align: left; border: 1px solid #0f172a;">ROTA (ORIGEM ➔ DESTINO)</th>
                    <th style="padding: 12px; text-align: center; border: 1px solid #0f172a;">PESO (t) x VALOR</th>
                    <th style="padding: 12px; text-align: right; border: 1px solid #0f172a;">TOTAL</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($fretes as $f): ?>
                <tr style="border-bottom: 1px solid #e2e8f0;">
                    <td style="padding: 12px;">
                        <strong><?php echo date('d/m/Y', strtotime($f['data_frete'])); ?></strong><br>
                        <span style="color: #ea580c; font-weight: bold;"><?php echo $f['placa']; ?></span>
                    </td>
                    <td style="padding: 12px;">
                        <span style="font-weight: 800; text-transform: uppercase;"><?php echo $f['origem']; ?></span><br>
                        <span style="color: #64748b;">➔ <?php echo $f['destino']; ?></span>
                    </td>
                    <td style="padding: 12px; text-align: center; background: #f8fafc;">
                        <?php echo number_format($f['total_ton'], 3, ',', '.'); ?> t<br>
                        <span style="font-size: 9px; color: #94a3b8;">x R$ <?php echo number_format($f['valor_ton'], 2, ',', '.'); ?></span>
                    </td>
                    <td style="padding: 12px; text-align: right; font-weight: 900; font-size: 13px;">
                        R$ <?php echo number_format($f['total_geral'], 2, ',', '.'); ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div style="margin-top: 30px; text-align: right; background: #0f172a; color: white; padding: 20px; border-radius: 10px;">
            <p style="font-size: 11px; font-weight: bold; color: #ea580c; text-transform: uppercase; margin-bottom: 5px;">Faturamento Total do Período</p>
            <h2 style="font-size: 28px; font-weight: 900; font-style: italic; margin: 0;">R$ <?php echo number_format($total_periodo, 2, ',', '.'); ?></h2>
        </div>

        <div style="margin-top: 40px; text-align: center; border-top: 1px dashed #cbd5e1; padding-top: 15px;">
            <p style="font-size: 9px; color: #94a3b8; text-transform: uppercase; letter-spacing: 2px;">Rota Prime - Gerenciamento de Alta Performance</p>
        </div>
    </div>

    <script>
        function baixarRelatorioPDF() {
            const btn = document.getElementById('btn-pdf');
            const elemento = document.getElementById('relatorio-conteudo');
            
            btn.innerHTML = '<i class="fa-solid fa-spinner fa-spin mr-2"></i> GERANDO PDF...';
            btn.disabled = true;

            const opt = {
                margin:       10,
                filename:     'Relatorio_RotaPrime_<?php echo date('dmY'); ?>.pdf',
                image:        { type: 'jpeg', quality: 0.98 },
                html2canvas:  { scale: 2, useCORS: true },
                jsPDF:        { unit: 'mm', format: 'a4', orientation: 'portrait' }
            };

            // Gera e baixa o arquivo
            html2pdf().set(opt).from(elemento).save().then(() => {
                btn.innerHTML = '<i class="fa-solid fa-check mr-2"></i> PDF BAIXADO!';
                btn.disabled = false;
                setTimeout(() => {
                    btn.innerHTML = '<i class="fa-solid fa-file-pdf mr-2 text-lg"></i> BAIXAR RELATÓRIO PDF';
                }, 3000);
            }).catch(err => {
                alert("Erro ao baixar. Tente abrir no Chrome.");
                btn.innerHTML = 'ERRO AO GERAR';
                btn.disabled = false;
            });
        }
    </script>
</body>
</html>