<?php
session_start();
require_once 'config.php';

// Se já estiver logado como admin, vai direto
if (isset($_SESSION['nivel']) && $_SESSION['nivel'] == 'admin') {
    header("Location: admin.php"); exit();
}

$erro = $_GET['error'] ?? '';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acesso Master - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background-color: #020617; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input { background: #0f172a !important; color: white !important; border: 1px solid #1e293b !important; }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-6">
    <div class="max-w-md w-full">
        <div class="text-center mb-8">
            <h1 class="text-2xl font-black italic text-orange-500 uppercase">ROTA PRIME <span class="text-white">ADMIN</span></h1>
            <p class="text-slate-500 text-xs uppercase tracking-widest mt-2">Área Restrita de Gestão Master</p>
        </div>

        <div class="glass p-8 rounded-[40px] shadow-2xl">
            <?php if($erro): ?>
                <div class="bg-red-500/10 text-red-500 text-xs p-4 rounded-xl mb-6 text-center font-bold"><?php echo $erro; ?></div>
            <?php endif; ?>

            <form action="auth.php" method="POST" class="space-y-4">
                <input type="hidden" name="acao" value="login">
                <div>
                    <label class="text-[10px] text-slate-500 uppercase font-black ml-2 mb-1 block">E-mail Administrativo</label>
                    <input type="email" name="email" required class="w-full p-4 rounded-2xl text-sm outline-none focus:border-orange-500 transition">
                </div>
                <div>
                    <label class="text-[10px] text-slate-500 uppercase font-black ml-2 mb-1 block">Senha de Segurança</label>
                    <input type="password" name="senha" required class="w-full p-4 rounded-2xl text-sm outline-none focus:border-orange-500 transition">
                </div>
                <button type="submit" class="w-full bg-orange-500 text-slate-950 font-black py-5 rounded-2xl uppercase italic shadow-xl hover:scale-[1.02] transition">Autenticar Master</button>
            </form>
        </div>
        <p class="text-center text-slate-600 text-[10px] mt-8 uppercase font-bold tracking-tighter">Acesso monitorado por IP</p>
    </div>
</body>
</html>