<?php
session_start();
require_once 'config.php';

// Se já estiver logado como patrao, vai direto
if (isset($_SESSION['nivel']) && $_SESSION['nivel'] == 'patrao') {
    header("Location: painel.php"); exit();
}

$erro = $_GET['error'] ?? '';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel do Gestor - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { background-color: #020617; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input { background: #0f172a !important; color: white !important; border: 1px solid #1e293b !important; }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-6">
    <div class="max-w-md w-full">
        <div class="text-center mb-8">
            <h1 class="text-2xl font-black italic text-blue-500 uppercase">ROTA PRIME <span class="text-white">PATRÃO</span></h1>
            <p class="text-slate-500 text-xs uppercase tracking-widest mt-2">Controle de Frota e Comissões</p>
        </div>

        <div class="glass p-8 rounded-[40px] shadow-2xl border-t-4 border-blue-500">
            <?php if($erro): ?>
                <div class="bg-red-500/10 text-red-500 text-xs p-4 rounded-xl mb-6 text-center font-bold"><?php echo $erro; ?></div>
            <?php endif; ?>

            <form action="auth.php" method="POST" class="space-y-4">
                <input type="hidden" name="acao" value="login">
                <div>
                    <label class="text-[10px] text-slate-500 uppercase font-black ml-2 mb-1 block">E-mail Corporativo</label>
                    <input type="email" name="email" required class="w-full p-4 rounded-2xl text-sm outline-none focus:border-blue-500 transition">
                </div>
                <div>
                    <label class="text-[10px] text-slate-500 uppercase font-black ml-2 mb-1 block">Senha de Acesso</label>
                    <input type="password" name="senha" required class="w-full p-4 rounded-2xl text-sm outline-none focus:border-blue-500 transition">
                </div>
                <button type="submit" class="w-full bg-blue-600 text-white font-black py-5 rounded-2xl uppercase italic shadow-xl hover:scale-[1.02] transition">Entrar no Painel Gestor</button>
            </form>
            <div class="mt-6 text-center">
                <a href="fretes.php" class="text-slate-500 text-[10px] uppercase font-black hover:text-white transition">Voltar para Início</a>
            </div>
        </div>
    </div>
</body>
</html>