<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once 'config.php';

if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] !== 'patrao') {
    header("Location: fretes.php"); exit();
}

$codigo_empresa = $_SESSION['codigo_empresa'];
$usuario_id = $_SESSION['usuario_id'];

// --- LÓGICA: SALVAR MANUTENÇÃO ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['acao'])) {
    $veiculo_id = $_POST['veiculo_id'];
    $tag = $_POST['tag']; 
    $descricao = strtoupper(trim($_POST['descricao']));
    $valor = $_POST['valor'];
    $km_manutencao = $_POST['km_manutencao'] ?? 0;
    $data_manutencao = $_POST['data_manutencao'];

    // Inserindo na tabela despesas categorizado como Manutenção
    $stmt = $pdo->prepare("INSERT INTO despesas (codigo_empresa, usuario_id, veiculo_id, tipo_despesa, tag, valor_total, km_atual, descricao_geral, data_despesa) VALUES (?, ?, ?, 'Manutenção', ?, ?, ?, ?, ?)");
    
    if($stmt->execute([$codigo_empresa, $usuario_id, $veiculo_id, $tag, $valor, $km_manutencao, $descricao, $data_manutencao])) {
        header("Location: manutencao_frota.php?sucesso=1"); 
        exit();
    }
}

// --- BUSCA VEÍCULOS PARA O SELECT ---
$stmt_v = $pdo->prepare("SELECT id, placa, modelo FROM veiculos WHERE codigo_empresa = ? ORDER BY placa ASC");
$stmt_v->execute([$codigo_empresa]);
$veiculos = $stmt_v->fetchAll(PDO::FETCH_ASSOC);

// --- BUSCA ÚLTIMOS LANÇAMENTOS (CORRIGIDO) ---
// Buscamos tanto o que o patrão lança como "Manutenção" quanto o que o motorista lança
$stmt_m = $pdo->prepare("
    SELECT d.*, v.placa, v.modelo 
    FROM despesas d
    INNER JOIN veiculos v ON d.veiculo_id = v.id 
    WHERE d.codigo_empresa = ? 
    AND (d.tipo_despesa = 'Manutenção' OR d.tag IS NOT NULL)
    ORDER BY d.data_despesa DESC, d.id DESC 
    LIMIT 20
");
$stmt_m->execute([$codigo_empresa]);
$manutencoes = $stmt_m->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manutenção de Frota - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input, select { background: #0f172a !important; border: 1px solid #1e293b !important; color: white !important; outline: none; }
    </style>
</head>
<body class="pb-20">

    <header class="p-6 max-w-4xl mx-auto flex justify-between items-center">
        <a href="painel_patrao.php" class="text-slate-500 hover:text-white transition-all"><i class="fa-solid fa-arrow-left mr-2"></i> Painel</a>
        <h1 class="text-orange-500 font-black italic text-xl uppercase">Oficina & Frota</h1>
        <div class="w-10"></div>
    </header>

    <main class="max-w-4xl mx-auto px-4">
        
        <section class="glass p-6 rounded-[35px] mb-8 border-orange-500/20">
            <h3 class="text-[10px] font-black uppercase text-orange-500 mb-4 italic italic tracking-[2px]">Novo Registro de Manutenção</h3>
            <form method="POST" class="space-y-4">
                <input type="hidden" name="acao" value="salvar">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Veículo</label>
                        <select name="veiculo_id" required class="w-full p-4 rounded-2xl text-xs font-bold mt-1 uppercase">
                            <option value="">Selecione a Placa</option>
                            <?php foreach($veiculos as $v): ?>
                                <option value="<?= $v['id'] ?>"><?= $v['placa'] ?> - <?= $v['modelo'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Categoria</label>
                        <select name="tag" required class="w-full p-4 rounded-2xl text-xs font-bold mt-1 uppercase">
                            <option value="Mecânica">Mecânica / Peças</option>
                            <option value="Pneus">Pneus</option>
                            <option value="Óleo/Filtros">Troca de Óleo / Filtros</option>
                            <option value="Elétrica">Elétrica</option>
                            <option value="Estética">Lavagem / Estética</option>
                            <option value="Documento">Documentação</option>
                            <option value="Documento">Outros</option>
                        </select>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-1 gap-4">
                    <input type="text" name="descricao" placeholder="O QUE FOI FEITO? (EX: TROCA DE LONAS DE FREIO)" required class="p-4 rounded-2xl text-xs font-bold uppercase w-full">
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <input type="number" step="0.01" name="valor" placeholder="VALOR TOTAL (R$)" required class="p-4 rounded-2xl text-xs font-bold text-orange-500">
                    <input type="number" name="km_manutencao" placeholder="KM ATUAL" required class="p-4 rounded-2xl text-xs font-bold">
                    <input type="date" name="data_manutencao" value="<?= date('Y-m-d') ?>" required class="p-4 rounded-2xl text-xs font-bold uppercase">
                </div>

                <button type="submit" class="w-full bg-orange-500 text-slate-950 font-black p-5 rounded-2xl text-[11px] uppercase italic hover:bg-orange-400 transition-all shadow-lg shadow-orange-500/20">
                    <i class="fa-solid fa-check mr-2"></i> Gravar Manutenção
                </button>
            </form>
        </section>

        <h3 class="text-[10px] font-black uppercase text-slate-500 px-2 mb-3 tracking-widest flex justify-between">
            <span>Histórico Recente</span>
            <span><?= count($manutencoes) ?> lançamentos</span>
        </h3>

        <div class="space-y-3">
            <?php if (empty($manutencoes)): ?>
                <div class="glass p-10 rounded-[35px] text-center">
                    <p class="text-slate-500 text-xs font-bold uppercase">Nenhum registro encontrado.</p>
                </div>
            <?php endif; ?>

            <?php foreach($manutencoes as $m): ?>
            <div class="glass p-5 rounded-[30px] border border-white/5 flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                <div class="flex items-center gap-4">
                    <div class="bg-orange-500/10 text-orange-500 p-3 rounded-2xl text-center min-w-[80px]">
                        <span class="text-[10px] font-black block leading-none uppercase italic"><?= $m['placa'] ?></span>
                    </div>
                    <div>
                        <div class="flex items-center gap-2">
                            <span class="text-[8px] bg-white/10 text-slate-400 px-2 py-0.5 rounded-full font-black uppercase italic"><?= $m['tag'] ?: 'Geral' ?></span>
                            <span class="text-[8px] text-slate-500 font-bold"><?= date('d/m/Y', strtotime($m['data_despesa'])) ?></span>
                        </div>
                        <h4 class="font-black italic text-sm uppercase mt-1 text-slate-200 leading-tight"><?= $m['descricao_geral'] ?></h4>
                        <p class="text-[9px] text-slate-500 font-bold uppercase mt-1">KM: <?= number_format($m['km_atual'], 0, '', '.') ?> • Veículo: <?= $m['modelo'] ?></p>
                    </div>
                </div>
                <div class="w-full md:w-auto text-right">
                    <p class="text-lg font-black text-white italic">R$ <?= number_format($m['valor_total'], 2, ',', '.') ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </main>

</body>
</html>