<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once 'config.php';
date_default_timezone_set('America/Sao_Paulo');

if (!isset($_SESSION['usuario_id'])) { 
    header("Location: login.php"); 
    exit(); 
}

$usuario_id = $_SESSION['usuario_id'];
$codigo_empresa = $_SESSION['codigo_empresa'];

// --- LÓGICA DE INSERÇÃO ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $veiculo_id = $_POST['veiculo_id'];
        $origem = strtoupper(trim($_POST['origem']));
        $destino = strtoupper(trim($_POST['destino']));
        
        // No seu formulário o nome é 'peso', mas no banco vamos gravar em 'total_ton'
        $peso = str_replace(',', '.', $_POST['peso']);
        
        // No seu formulário é 'preco_ton', mas no banco vamos gravar em 'valor_ton'
        $valor_unitario = str_replace(',', '.', $_POST['preco_ton']);
        
        $data = $_POST['data_frete'];

        // Cálculo do total geral (comissão do motorista)
        $total_geral = (float)$peso * (float)$valor_unitario;

        // SQL AJUSTADO CONFORME O SEU DESCRIBE FRETES
        $sql = "INSERT INTO fretes (
                    usuario_id, 
                    codigo_empresa, 
                    veiculo_id, 
                    origem, 
                    destino, 
                    total_ton, 
                    valor_ton, 
                    total_geral, 
                    data_frete, 
                    status_pagamento
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'Pendente')";
        
        $stmt = $pdo->prepare($sql);
        
        $stmt->execute([
            $usuario_id, 
            $codigo_empresa, 
            $veiculo_id, 
            $origem, 
            $destino, 
            $peso, 
            $valor_unitario, 
            $total_geral, 
            $data
        ]);

        header("Location: painel.php?sucesso=1"); 
        exit();

    } catch (PDOException $e) {
        die("Erro Crítico no Banco de Dados: " . $e->getMessage());
    }
}

// --- BUSCA VEÍCULOS PARA O SELECT ---
$stmt_vei = $pdo->prepare("SELECT id, placa FROM veiculos WHERE codigo_empresa = ? ORDER BY placa ASC");
$stmt_vei->execute([$codigo_empresa]);
$veiculos = $stmt_vei->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Novo Frete - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.6); backdrop-filter: blur(12px); border: 1px solid rgba(255,255,255,0.05); }
        input, select { background: #0f172a !important; border: 1px solid #1e293b !important; color: white !important; outline: none !important; }
        input:focus { border-color: #f97316 !important; }
    </style>
</head>
<body class="p-6 pb-20">
    <header class="max-w-xl mx-auto mb-8 flex items-center justify-between">
        <a href="painel.php" class="text-slate-500 hover:text-white transition-all">
            <i class="fa-solid fa-chevron-left mr-2"></i> Voltar
        </a>
        <h1 class="text-orange-500 font-black italic uppercase tracking-tighter">Lançar Viagem</h1>
        <div class="w-10"></div>
    </header>

    <main class="max-w-xl mx-auto">
        <form method="POST" class="glass p-8 rounded-[35px] space-y-5 border border-white/5 shadow-2xl">
            
            <div>
                <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Caminhão / Placa</label>
                <select name="veiculo_id" required class="w-full p-4 rounded-2xl text-xs font-bold uppercase mt-1">
                    <option value="">Selecione o Veículo</option>
                    <?php foreach($veiculos as $v): ?>
                        <option value="<?= $v['id'] ?>"><?= $v['placa'] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="grid grid-cols-2 gap-3">
                <div>
                    <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Origem</label>
                    <input type="text" name="origem" placeholder="CIDADE" required class="w-full p-4 rounded-2xl text-xs font-bold uppercase mt-1">
                </div>
                <div>
                    <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Destino</label>
                    <input type="text" name="destino" placeholder="CIDADE" required class="w-full p-4 rounded-2xl text-xs font-bold uppercase mt-1">
                </div>
            </div>

            <div class="grid grid-cols-2 gap-3">
                <div>
                    <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Peso (Ton)</label>
                    <input type="number" step="0.001" name="peso" placeholder="0.000" required class="w-full p-4 rounded-2xl text-xs font-bold mt-1">
                </div>
                <div>
                    <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Valor Ton (Motorista)</label>
                    <input type="number" step="0.01" name="preco_ton" placeholder="R$ 0,00" required class="w-full p-4 rounded-2xl text-xs font-bold mt-1 text-orange-500">
                </div>
            </div>

            <div>
                <label class="text-[10px] font-black uppercase text-slate-500 ml-2 italic">Data da Viagem</label>
                <input type="date" name="data_frete" value="<?= date('Y-m-d') ?>" required class="w-full p-4 rounded-2xl text-xs font-bold uppercase mt-1">
            </div>

            <button type="submit" class="w-full bg-orange-500 text-slate-950 p-5 rounded-2xl font-black uppercase italic shadow-lg shadow-orange-500/30 mt-6 hover:bg-orange-400 active:scale-95 transition-all">
                <i class="fa-solid fa-check-circle mr-2"></i> Confirmar Viagem
            </button>
        </form>
    </main>
</body>
</html>