<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ativação de Conta - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .card { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        .btn-whatsapp { background-color: #25d366; color: white; transition: 0.3s; }
        .btn-whatsapp:hover { background-color: #128c7e; transform: scale(1.02); }
        .plano-label { font-size: 8px; letter-spacing: 2px; }
    </style>
</head>
<body class="min-h-screen flex flex-col items-center p-4">

    <header class="w-full max-w-2xl text-center py-8">
        <h1 class="text-3xl font-black text-orange-500 uppercase italic tracking-tighter">ROTA <span class="text-white">PRIME</span></h1>
        <p class="text-slate-400 text-sm mt-2 uppercase tracking-widest font-bold">Ativação de Assinatura</p>
    </header>

    <main class="w-full max-w-4xl space-y-6">
        
        <div class="bg-blue-600/10 border border-blue-500/50 p-4 rounded-2xl text-center text-blue-200">
            <i class="fas fa-clock mr-2 animate-pulse"></i> 
            <strong>TESTE GRÁTIS ATIVO:</strong> O sistema está liberado por <strong>7 dias</strong> para novos cadastros. Após o prazo, escolha um plano para manter o acesso.
        </div>

        <h2 class="text-[10px] font-black uppercase text-slate-500 tracking-[0.3em] text-center italic">Para Motoristas Autônomos</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="card p-6 rounded-[32px] relative overflow-hidden border-slate-700 border">
                <h3 class="text-lg font-black uppercase italic mb-2 text-slate-400">Plano Mensal</h3>
                <div class="text-4xl font-black mb-4 text-white">R$ 49,90<span class="text-sm text-slate-500 font-normal">/mês</span></div>
                <ul class="text-xs text-slate-400 space-y-3 font-bold uppercase tracking-tight">
                    <li><i class="fas fa-check text-orange-500 mr-2"></i> Gestão de Fretes Ilimitada</li>
                    <li><i class="fas fa-check text-orange-500 mr-2"></i> Carteira de Sócios Ativa</li>
                </ul>
            </div>

            <div class="card p-6 rounded-[32px] border-orange-500/50 border-2 relative overflow-hidden bg-orange-500/5">
                <div class="absolute top-0 right-0 bg-orange-500 text-slate-950 text-[9px] font-black px-4 py-1 uppercase italic">Motorista VIP</div>
                <h3 class="text-lg font-black uppercase italic mb-2 text-orange-500">Plano Anual</h3>
                <div class="text-4xl font-black mb-4 text-white">R$ 240,00<span class="text-sm text-slate-500 font-normal">/ano</span></div>
                <p class="text-[10px] text-emerald-400 font-black mb-4 uppercase italic">Economia de R$ 358,80 por ano!</p>
            </div>
        </div>

        <h2 class="text-[10px] font-black uppercase text-slate-500 tracking-[0.3em] text-center italic pt-6">Para Empresas e Frotas</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="card p-5 rounded-[25px] border-slate-800 border">
                <span class="text-orange-500 font-black plano-label uppercase italic">Plano A</span>
                <p class="text-[9px] font-bold text-slate-500 mb-2 uppercase">Até 10 Funcionários</p>
                <div class="text-2xl font-black text-white">R$ 240,00<span class="text-[10px] text-slate-600 font-normal">/mês</span></div>
            </div>
            <div class="card p-5 rounded-[25px] border-orange-500/30 border bg-orange-500/5">
                <span class="text-orange-500 font-black plano-label uppercase italic">Plano B</span>
                <p class="text-[9px] font-bold text-slate-500 mb-2 uppercase">Até 20 Funcionários</p>
                <div class="text-2xl font-black text-white">R$ 480,00<span class="text-[10px] text-slate-600 font-normal">/mês</span></div>
            </div>
            <div class="card p-5 rounded-[25px] border-slate-800 border">
                <span class="text-orange-500 font-black plano-label uppercase italic">Plano C</span>
                <p class="text-[9px] font-bold text-slate-500 mb-2 uppercase">Acima de 30 Funcionários</p>
                <div class="text-2xl font-black text-white">R$ 1.000,00<span class="text-[10px] text-slate-600 font-normal">/mês</span></div>
            </div>
        </div>

        <div class="card p-8 rounded-[40px] text-center shadow-2xl">
            <h4 class="text-xs font-black mb-6 uppercase tracking-[0.3em] text-orange-500 italic">Pagamento via PIX</h4>
            
            <div class="bg-white p-4 rounded-3xl inline-block mb-6 border-4 border-slate-800">
                <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=magnotrader@gmail.com" alt="QR Code PIX">
            </div>

            <div class="space-y-3 max-w-xs mx-auto">
                <div onclick="copyPix()" class="bg-slate-950 p-4 rounded-2xl font-mono text-orange-400 flex items-center justify-between border border-slate-800 cursor-pointer active:scale-95 transition-all">
                    <span id="chavePix" class="text-sm truncate mr-2">magnotrader@gmail.com</span>
                    <i class="fa-solid fa-copy text-slate-500"></i>
                </div>
            </div>

            <div class="mt-10 pt-8 border-t border-slate-800">
                <p class="text-xs font-bold text-slate-400 mb-6 uppercase">Enviar comprovante para ativação:</p>
                <a href="https://wa.me/5531995119050?text=Olá! Fiz o pagamento do plano ROTA PRIME. Segue o comprovante." 
                   target="_blank"
                   class="btn-whatsapp w-full flex items-center justify-center gap-3 py-5 rounded-2xl font-black text-sm uppercase italic tracking-widest shadow-lg shadow-emerald-500/20 transition-all">
                    <i class="fab fa-whatsapp text-xl"></i>
                    Enviar Comprovante
                </a>
            </div>
        </div>

        <p class="text-center text-slate-600 text-[10px] font-black uppercase tracking-widest pb-10">
            ROTA PRIME • Gestão Logística Profissional © 2025
        </p>
    </main>

    <script>
        function copyPix() {
            const text = "magnotrader@gmail.com";
            navigator.clipboard.writeText(text).then(() => {
                alert("Chave PIX copiada!");
            });
        }
    </script>
</body>
</html>