<?php
session_start();
require_once 'config.php';
date_default_timezone_set('America/Sao_Paulo');

if (!isset($_SESSION['usuario_id'])) {
    header("Location: fretes.php");
    exit();
}

$usuario_id = $_SESSION['usuario_id'];
$codigo_empresa = $_SESSION['codigo_empresa'] ?? null;

// --- DADOS DO USUÁRIO ---
$stmt_user = $pdo->prepare("SELECT nome, foto, nivel FROM usuarios WHERE id = ?");
$stmt_user->execute([$usuario_id]);
$dados_usuario = $stmt_user->fetch(PDO::FETCH_ASSOC);

// --- FILTRO DE DATAS ---
$data_inicio = $_GET['f_inicio'] ?? date('Y-m-01');
$data_fim = $_GET['f_fim'] ?? date('Y-m-t');

// --- BUSCA FRETES ---
$stmt = $pdo->prepare("SELECT * FROM fretes WHERE usuario_id = ? AND data_frete BETWEEN ? AND ? ORDER BY data_frete DESC");
$stmt->execute([$usuario_id, $data_inicio, $data_fim]);
$fretes = $stmt->fetchAll(PDO::FETCH_ASSOC);

$saldo_pendente = 0;
$total_recebido = 0;

foreach ($fretes as $f) {
    if (($f['status_pagamento'] ?? 'Pendente') == 'Pendente') {
        $saldo_pendente += (float)$f['total_geral'];
    } else {
        $total_recebido += (float)$f['total_geral'];
    }
}

// --- BUSCA DESPESAS ---
$stmt_d = $pdo->prepare("SELECT * FROM despesas WHERE usuario_id = ? AND data_despesa BETWEEN ? AND ? ORDER BY data_despesa DESC");
$stmt_d->execute([$usuario_id, $data_inicio, $data_fim]);
$despesas = $stmt_d->fetchAll(PDO::FETCH_ASSOC);

$total_despesas_motorista = 0;
foreach ($despesas as $d) {
    $total_despesas_motorista += (float)$d['valor_total'];
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>ROTA PRIME - Painel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.6); backdrop-filter: blur(12px); border: 1px solid rgba(255,255,255,0.05); }
        .tab-shadow { shadow-[0_-10px_30px_rgba(0,0,0,0.5)]; }
    </style>
</head>
<body class="pb-32">

    <header class="p-6 max-w-2xl mx-auto flex justify-between items-center">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 bg-orange-500 rounded-2xl flex items-center justify-center text-slate-900 font-black italic border-2 border-slate-800 rotate-3 overflow-hidden text-xl text-center">
                <?php echo strtoupper(substr($dados_usuario['nome'], 0, 1)); ?>
            </div>
            <div>
                <div class="inline-block bg-orange-500 text-slate-900 px-3 py-0.5 skew-x-[-15deg] font-black text-lg italic uppercase leading-none">ROTA PRIME</div>
                <p class="text-[10px] text-slate-500 font-bold uppercase mt-1 tracking-tighter">Olá, <?php echo explode(' ', $dados_usuario['nome'])[0]; ?></p>
            </div>
        </div>
        <a href="logout.php" class="text-slate-600 hover:text-red-500 transition-colors"><i class="fa-solid fa-power-off text-xl"></i></a>
    </header>

    <main class="max-w-2xl mx-auto px-4">
        
        <div class="grid grid-cols-1 gap-4 mb-6">
            <div class="glass p-6 rounded-[35px] border-l-8 border-l-orange-500 shadow-xl shadow-orange-500/5">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Comissão a Receber</p>
                        <h2 class="text-4xl font-black italic text-white tracking-tighter">R$ <?php echo number_format($saldo_pendente, 2, ',', '.'); ?></h2>
                    </div>
                    <div class="text-right">
                        <p class="text-[9px] font-bold text-green-500 uppercase italic">Já Pago</p>
                        <p class="text-sm font-black text-slate-400">R$ <?php echo number_format($total_recebido, 2, ',', '.'); ?></p>
                    </div>
                </div>
            </div>

            <div class="glass p-5 rounded-[30px] border-l-8 border-l-red-500">
                <div class="flex justify-between items-center">
                    <div>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-1">Gasto em Viagem (Empresa)</p>
                        <h3 class="text-2xl font-black italic text-red-400">R$ <?php echo number_format($total_despesas_motorista, 2, ',', '.'); ?></h3>
                    </div>
                    <i class="fa-solid fa-gas-pump text-red-500/20 text-3xl"></i>
                </div>
                <p class="text-[8px] text-slate-500 mt-2 font-bold uppercase italic">*Lançamentos de diesel e despesas de rota.</p>
            </div>
        </div>

        <div class="grid grid-cols-2 gap-3 mb-8">
            <a href="novo_frete.php" class="bg-orange-500 text-slate-950 p-4 rounded-2xl font-black uppercase text-[10px] text-center flex flex-col items-center gap-1 shadow-lg shadow-orange-500/20 active:scale-95 transition-transform">
                <i class="fa-solid fa-plus-circle text-lg"></i> Novo Frete
            </a>
            <a href="despesas_motorista.php" class="bg-red-500 text-white p-4 rounded-2xl font-black uppercase text-[10px] text-center flex flex-col items-center gap-1 shadow-lg shadow-red-500/20 active:scale-95 transition-transform">
                <i class="fa-solid fa-gas-pump text-lg"></i> Lançar Despesa
            </a>
        </div>

        <div class="mb-10">
            <h3 class="text-[10px] font-black uppercase text-orange-500 mb-3 px-2 flex justify-between tracking-widest italic">
                <span>Minhas Viagens</span>
                <span class="text-slate-500"><?php echo count($fretes); ?> Viagens</span>
            </h3>
            <div class="space-y-3">
                <?php if(count($fretes) > 0): foreach ($fretes as $f): 
                    $status = $f['status_pagamento'] ?? 'Pendente';
                ?>
                <div class="glass p-4 rounded-[25px] border border-white/5 shadow-sm relative group">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="text-[9px] font-bold text-slate-500 uppercase"><?php echo date('d/m/Y', strtotime($f['data_frete'])); ?></p>
                            <h4 class="font-black italic text-sm uppercase text-slate-200"><?php echo htmlspecialchars($f['origem']); ?> / <?php echo htmlspecialchars($f['destino']); ?></h4>
                            <div class="flex gap-4 mt-2">
                                <a href="editar_frete.php?id=<?php echo $f['id']; ?>" class="text-[9px] uppercase font-black text-orange-500/70 hover:text-orange-500"><i class="fa-solid fa-pen-to-square mr-1"></i> Editar</a>
                                <a href="excluir_frete.php?id=<?php echo $f['id']; ?>" onclick="return confirm('Excluir esta viagem?')" class="text-[9px] uppercase font-black text-red-500/50 hover:text-red-500"><i class="fa-solid fa-trash mr-1"></i> Excluir</a>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-black <?php echo $status == 'Pago' ? 'text-green-500' : 'text-white'; ?> italic">
                                R$ <?php echo number_format($f['total_geral'], 2, ',', '.'); ?>
                            </p>
                            <span class="text-[8px] font-black uppercase px-2 py-0.5 rounded-full <?php echo $status == 'Pago' ? 'bg-green-500/10 text-green-500 border border-green-500/20' : 'bg-slate-700/50 text-slate-400 border border-white/5'; ?>">
                                <?php echo $status; ?>
                            </span>
                        </div>
                    </div>
                </div>
                <?php endforeach; else: ?>
                    <p class="text-center text-[10px] text-slate-600 font-bold py-6 italic uppercase tracking-widest">Nenhuma viagem no período</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="mb-20">
            <h3 class="text-[10px] font-black uppercase text-red-500 mb-3 px-2 flex justify-between tracking-widest italic">
                <span>Saídas Lançadas</span>
                <span class="text-slate-500"><?php echo count($despesas); ?> Registros</span>
            </h3>
            <div class="space-y-3">
                <?php if(count($despesas) > 0): foreach ($despesas as $d): ?>
                <div class="glass p-4 rounded-[25px] border border-red-500/10 bg-red-500/[0.02]">
                    <div class="flex justify-between items-center">
                        <div class="flex-1">
                            <p class="text-[8px] font-bold text-red-400/50 uppercase leading-none mb-1"><?php echo date('d/m/Y', strtotime($d['data_despesa'])); ?> • <?php echo $d['tipo_despesa']; ?></p>
                            <h4 class="font-black italic text-[11px] uppercase text-slate-300 leading-tight">
                                <?php echo $d['tipo_despesa'] == 'Abastecimento' ? number_format($d['litros'], 2, ',', '.')."L Diesel (KM ".$d['km_atual'].")" : htmlspecialchars($d['descricao_geral']); ?>
                            </h4>
                            <div class="flex gap-4 mt-2">
                                <a href="editar_despesa.php?id=<?php echo $d['id']; ?>" class="text-[9px] uppercase font-black text-red-400/70 hover:text-red-400"><i class="fa-solid fa-pen-to-square mr-1"></i> Editar</a>
                                <a href="excluir_despesa.php?id=<?php echo $d['id']; ?>" onclick="return confirm('Excluir esta despesa?')" class="text-[9px] uppercase font-black text-red-900/50 hover:text-red-600"><i class="fa-solid fa-trash mr-1"></i> Excluir</a>
                            </div>
                        </div>
                        <p class="text-sm font-black text-red-400 italic">R$ <?php echo number_format($d['valor_total'], 2, ',', '.'); ?></p>
                    </div>
                </div>
                <?php endforeach; else: ?>
                    <p class="text-center text-[10px] text-slate-600 font-bold py-6 italic uppercase tracking-widest">Nenhuma despesa lançada</p>
                <?php endif; ?>
            </div>
        </div>

    </main>

    <nav class="fixed bottom-0 left-0 right-0 glass border-t border-white/5 p-4 flex justify-around items-center z-50 rounded-t-[35px] shadow-[0_-15px_40px_rgba(0,0,0,0.6)]">
        <a href="painel.php" class="text-orange-500 flex flex-col items-center gap-1 transition-all active:scale-90">
            <i class="fa-solid fa-house text-xl"></i>
            <span class="text-[8px] font-black uppercase tracking-tighter">Início</span>
        </a>
        
        <a href="novo_frete.php" class="bg-orange-500 text-slate-900 w-14 h-14 rounded-[22px] flex items-center justify-center -mt-14 border-8 border-[#020617] shadow-2xl transition-all active:scale-95 active:rotate-3">
            <i class="fa-solid fa-plus text-2xl"></i>
        </a>

        <a href="perfil.php" class="text-slate-500 flex flex-col items-center gap-1 transition-all active:scale-90">
            <i class="fa-solid fa-user text-xl"></i>
            <span class="text-[8px] font-black uppercase tracking-tighter">Perfil</span>
        </a>
    </nav>

</body>
</html>