<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once 'config.php';

if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] !== 'patrao') {
    header("Location: fretes.php");
    exit();
}

$codigo_empresa = $_SESSION['codigo_empresa'];

// --- LÓGICA: ALTERAR STATUS DE PAGAMENTO (EXISTENTE) ---
if (isset($_GET['toggle_status']) && isset($_GET['novo_status'])) {
    $id_frete = (int)$_GET['toggle_status'];
    $novo_status = $_GET['novo_status'];
    
    if (in_array($novo_status, ['Pago', 'Pendente'])) {
        $stmt = $pdo->prepare("UPDATE fretes SET status_pagamento = ? WHERE id = ? AND codigo_empresa = ?");
        $stmt->execute([$novo_status, $id_frete, $codigo_empresa]);
    }

    $query = $_GET;
    unset($query['toggle_status']);
    unset($query['novo_status']);
    $redirect = "painel_patrao.php" . (count($query) > 0 ? "?" . http_build_query($query) : "");
    header("Location: " . $redirect);
    exit();
}

// --- FILTROS ---
$f_motorista = $_GET['f_motorista'] ?? '';
$f_veiculo = $_GET['f_veiculo'] ?? '';
$f_inicio = $_GET['f_inicio'] ?? date('Y-m-01');
$f_fim = $_GET['f_fim'] ?? date('Y-m-t');

// BUSCA MOTORISTAS E VEÍCULOS PARA OS SELECTS
$stmt_mot = $pdo->prepare("SELECT id, nome FROM usuarios WHERE codigo_empresa = ? AND nivel = 'motorista' ORDER BY nome ASC");
$stmt_mot->execute([$codigo_empresa]);
$lista_motoristas = $stmt_mot->fetchAll(PDO::FETCH_ASSOC);

$stmt_vei = $pdo->prepare("SELECT id, placa FROM veiculos WHERE codigo_empresa = ? ORDER BY placa ASC");
$stmt_vei->execute([$codigo_empresa]);
$veiculos = $stmt_vei->fetchAll(PDO::FETCH_ASSOC);

// --- BUSCA FRETES ---
$params = [$codigo_empresa, $f_inicio, $f_fim];
$where_filtros = "";
if ($f_motorista) { $where_filtros .= " AND f.usuario_id = ? "; $params[] = $f_motorista; }
if ($f_veiculo) { $where_filtros .= " AND f.veiculo_id = ? "; $params[] = $f_veiculo; }

$sql = "SELECT f.*, u.nome as motorista, p.preco_ton_bruto, v.placa
        FROM fretes f 
        INNER JOIN usuarios u ON f.usuario_id = u.id 
        LEFT JOIN veiculos v ON f.veiculo_id = v.id
        LEFT JOIN precos_patrao p ON (p.origem = f.origem AND p.destino = f.destino AND p.codigo_empresa = f.codigo_empresa)
        WHERE f.codigo_empresa = ? AND f.data_frete BETWEEN ? AND ? $where_filtros
        ORDER BY f.data_frete DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$fretes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// --- BUSCA DESPESAS ---
$params_d = [$codigo_empresa, $f_inicio, $f_fim];
$sql_d = "SELECT d.*, u.nome as motorista, v.placa as placa_veiculo 
          FROM despesas d 
          LEFT JOIN usuarios u ON d.usuario_id = u.id 
          LEFT JOIN veiculos v ON d.veiculo_id = v.id
          WHERE d.codigo_empresa = ? AND d.data_despesa BETWEEN ? AND ?";
if($f_motorista) { $sql_d .= " AND d.usuario_id = ?"; $params_d[] = $f_motorista; }
if($f_veiculo) { $sql_d .= " AND d.veiculo_id = ?"; $params_d[] = $f_veiculo; }

$stmt_d = $pdo->prepare($sql_d . " ORDER BY d.data_despesa DESC");
$stmt_d->execute($params_d);
$despesas = $stmt_d->fetchAll(PDO::FETCH_ASSOC);

$total_bruto_f = 0; 
$total_comissao_f = 0;
$total_despesas_f = 0;
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Patrão - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input, select { background: #0f172a !important; border: 1px solid #1e293b !important; color: white !important; outline: none; }
        ::-webkit-scrollbar { width: 0px; }
    </style>
</head>
<body class="pb-64">

   <header class="p-6 max-w-5xl mx-auto flex flex-col md:flex-row justify-between items-center gap-6">
        <h1 class="text-orange-500 font-black italic text-xl uppercase leading-none">
            ROTA PRIME <br>
            <span class="text-white/20 text-[10px] font-normal italic tracking-[4px]">ADMINISTRAÇÃO</span>
        </h1>
        
        <nav class="flex flex-wrap justify-center gap-2">
            <a href="painel_patrao.php" class="bg-orange-500 text-slate-950 p-3 px-5 rounded-2xl text-[10px] font-black uppercase italic shadow-lg shadow-orange-500/20">
                <i class="fa-solid fa-chart-pie mr-1"></i> Dashboard
            </a>
            <a href="gerenciar_precos.php" class="bg-slate-800 text-white p-3 px-5 rounded-2xl text-[10px] font-black uppercase italic border border-white/5">
                <i class="fa-solid fa-tag mr-1"></i> Preços
            </a>
            <a href="manutencao_frota.php" class="bg-slate-800 text-white p-3 px-5 rounded-2xl text-[10px] font-black uppercase italic border border-white/5">
                <i class="fa-solid fa-wrench mr-1"></i> Manutenção
            </a>
            <a href="veiculos.php" class="bg-slate-800 text-white p-3 px-5 rounded-2xl text-[10px] font-black uppercase italic border border-white/5">
                <i class="fa-solid fa-truck mr-1"></i> Frota
            </a>
            <a href="logout.php" class="bg-red-500/10 text-red-500 p-3 px-5 rounded-2xl text-[10px] font-black uppercase italic border border-red-500/20">
                <i class="fa-solid fa-power-off"></i>
            </a>
        </nav>
    </header>
   
    <main class="max-w-4xl mx-auto px-4">
        
        <section class="glass p-6 rounded-[35px] mb-6 border-white/5 shadow-2xl">
            <h3 class="text-[10px] font-black uppercase text-slate-500 mb-4 italic flex items-center gap-2"><i class="fa-solid fa-filter"></i> Filtrar Relatório</h3>
            <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-3">
                <select name="f_motorista" class="p-3 rounded-2xl text-[10px] font-bold uppercase">
                    <option value="">Motoristas</option>
                    <?php foreach($lista_motoristas as $m): ?>
                        <option value="<?php echo $m['id']; ?>" <?php echo ($f_motorista == $m['id']) ? 'selected' : ''; ?>><?php echo $m['nome']; ?></option>
                    <?php endforeach; ?>
                </select>
                <select name="f_veiculo" class="p-3 rounded-2xl text-[10px] font-bold uppercase">
                    <option value="">Veículos</option>
                    <?php foreach($veiculos as $v): ?>
                        <option value="<?php echo $v['id']; ?>" <?php echo ($f_veiculo == $v['id']) ? 'selected' : ''; ?>><?php echo $v['placa']; ?></option>
                    <?php endforeach; ?>
                </select>
                <input type="date" name="f_inicio" value="<?php echo $f_inicio; ?>" class="p-3 rounded-2xl text-[10px] font-bold">
                <input type="date" name="f_fim" value="<?php echo $f_fim; ?>" class="p-3 rounded-2xl text-[10px] font-bold">
                <button type="submit" class="bg-white text-slate-950 p-3 rounded-2xl font-black text-[10px] uppercase">Aplicar</button>
            </form>
        </section>

        <div class="space-y-4">
            <h3 class="text-[10px] font-black uppercase text-orange-500 mb-2 italic px-2 tracking-widest">Relatório de Viagens</h3>
            <?php foreach ($fretes as $f): 
                $pb = (float)($f['preco_ton_bruto'] ?? 0);
                $peso = (float)($f['peso_ton'] ?? ($f['total_ton'] ?? 0));
                $bruto = $peso * $pb;
                $comissao = (float)$f['total_geral'];
                $total_bruto_f += $bruto; 
                $total_comissao_f += $comissao;
                $pago = ($f['status_pagamento'] == 'Pago');
                $link_status = "painel_patrao.php?" . http_build_query(array_merge($_GET, ['toggle_status' => $f['id'], 'novo_status' => $pago ? 'Pendente' : 'Pago']));
            ?>
            <div class="glass p-5 rounded-[30px] border-l-4 <?php echo $pago ? 'border-blue-500' : 'border-green-500'; ?>">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <div class="flex items-center gap-2 mb-2">
                            <span class="text-[8px] font-black bg-orange-500 text-slate-950 px-2 py-0.5 rounded-full uppercase"><?php echo htmlspecialchars($f['motorista']); ?></span>
                            <a href="<?php echo $link_status; ?>" class="<?php echo $pago ? 'bg-blue-500 text-white' : 'bg-slate-700 text-slate-400'; ?> text-[8px] font-black px-3 py-1 rounded-full uppercase italic">
                                <?php echo $pago ? 'PAGO' : 'PENDENTE'; ?>
                            </a>
                        </div>
                        <h4 class="font-black italic uppercase text-sm leading-tight"><?php echo htmlspecialchars($f['origem']); ?> <span class="text-orange-500">/</span> <?php echo htmlspecialchars($f['destino']); ?></h4>
                        <p class="text-[9px] text-slate-500 font-bold uppercase mt-1">Data: <?php echo date('d/m/Y', strtotime($f['data_frete'])); ?> | Placa: <?php echo $f['placa']; ?></p>
                    </div>
                </div>

                <div class="grid grid-cols-3 gap-2">
                    <div class="bg-black/40 p-3 rounded-2xl text-center"><p class="text-[7px] text-slate-500 uppercase font-black">Faturamento</p><p class="text-xs font-black">R$ <?php echo number_format($bruto, 2, ',', '.'); ?></p></div>
                    <div class="bg-black/40 p-3 rounded-2xl text-center"><p class="text-[7px] text-slate-500 uppercase font-black">Comissão</p><p class="text-xs font-black">R$ <?php echo number_format($comissao, 2, ',', '.'); ?></p></div>
                    <div class="bg-orange-500/10 p-3 rounded-2xl text-center"><p class="text-[7px] font-black uppercase text-orange-500">Sobra</p><p class="text-xs font-black text-orange-500 italic">R$ <?php echo number_format($bruto - $comissao, 2, ',', '.'); ?></p></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <div class="mt-10 space-y-4">
            <h3 class="text-[10px] font-black uppercase text-red-500 italic px-2 tracking-widest">Extrato de Saídas</h3>
            <?php foreach ($despesas as $d): $total_despesas_f += (float)$d['valor_total']; ?>
            <div class="glass p-4 rounded-[25px] border-l-4 border-red-500 bg-red-500/5">
                <div class="flex justify-between items-center">
                    <div>
                        <span class="text-[7px] font-black bg-red-600 text-white px-2 py-0.5 rounded-full uppercase"><?php echo $d['tag'] ?: $d['tipo_despesa']; ?></span>
                        <p class="text-xs font-black mt-1 uppercase italic text-slate-300"><?php echo $d['tipo_despesa'] == 'Abastecimento' ? number_format($d['litros'], 2).'L Diesel' : htmlspecialchars($d['descricao_geral']); ?></p>
                        <p class="text-[8px] text-slate-500 uppercase font-black"><?php echo $d['motorista']; ?> | <?php echo date('d/m/Y', strtotime($d['data_despesa'])); ?> | <?php echo $d['placa_veiculo']; ?></p>
                    </div>
                    <p class="text-sm font-black text-red-400 italic">R$ <?php echo number_format($d['valor_total'], 2, ',', '.'); ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <div class="fixed bottom-0 left-0 right-0 p-4 z-50">
            <div class="max-w-4xl mx-auto glass p-6 rounded-[35px] border-t-2 border-orange-500 shadow-[0_-20px_50px_rgba(0,0,0,0.5)]">
                <div class="grid grid-cols-3 gap-4 mb-4 border-b border-white/5 pb-4">
                    <div><p class="text-[7px] font-black text-slate-500 uppercase italic">Faturamento Bruto</p><p class="text-sm font-black text-white italic">R$ <?php echo number_format($total_bruto_f, 2, ',', '.'); ?></p></div>
                    <div><p class="text-[7px] font-black text-slate-500 uppercase italic">Total Comissões</p><p class="text-sm font-black text-white italic">R$ <?php echo number_format($total_comissao_f, 2, ',', '.'); ?></p></div>
                    <div><p class="text-[7px] font-black text-slate-500 uppercase italic">Total Saídas</p><p class="text-sm font-black text-red-400 italic">R$ <?php echo number_format($total_despesas_f, 2, ',', '.'); ?></p></div>
                </div>
                <div class="flex justify-between items-center">
                    <p class="text-[10px] font-black text-orange-500 uppercase italic tracking-widest">Lucro Líquido Real da Empresa</p>
                    <p class="text-3xl font-black italic text-orange-500 tracking-tighter">
                        R$ <?php echo number_format($total_bruto_f - $total_comissao_f - $total_despesas_f, 2, ',', '.'); ?>
                    </p>
                </div>
            </div>
        </div>
    </main>

</body>
</html>