<?php
session_start();
require_once 'config.php';

if (!isset($_SESSION['usuario_id'])) { 
    header("Location: fretes.php"); 
    exit; 
}

$usuario_id = $_SESSION['usuario_id'];
$mensagem = '';
$tipo_msg = '';

try {
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$usuario_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Geração automática de código de indicação
    if (empty($user['codigo_indicacao'])) {
        $novo_codigo = "RP" . strtoupper(substr(md5($usuario_id . time()), 0, 6));
        $pdo->prepare("UPDATE usuarios SET codigo_indicacao = ? WHERE id = ?")->execute([$novo_codigo, $usuario_id]);
        $codigo_ref = $novo_codigo;
    } else {
        $codigo_ref = $user['codigo_indicacao'];
    }

    $usuario_nome = $user['nome'] ?? 'Motorista';
    $usuario_email = $user['email'] ?? 'Não informado';
    $usuario_whatsapp = $user['whatsapp'] ?? 'Não informado';
    $foto_atual = $user['foto'] ?? null;
    $data_criacao = (!empty($user['data_cadastro'])) ? date('d/m/Y', strtotime($user['data_cadastro'])) : date('d/m/Y');

    // --- LÓGICA DE SALDO DINÂMICO ---
    // 1. Conta indicados que já pagaram (status = 'pago')
    $stmt_saldo = $pdo->prepare("SELECT COUNT(*) as total_indicados FROM usuarios WHERE indicado_por = ? AND status = 'pago'");
    $stmt_saldo->execute([$codigo_ref]);
    $dados_saldo = $stmt_saldo->fetch();
    $total_pagantes = $dados_saldo['total_indicados'] ?? 0;
    
    $valor_por_indicacao = 10.00; // R$ 10,00 por amigo que assinar
    $saldo_total_acumulado = $total_pagantes * $valor_por_indicacao;

    // 2. Desconta saques já realizados e pagos
    $stmt_sacado = $pdo->prepare("SELECT SUM(valor) as total_sacado FROM saques WHERE usuario_id = ? AND status = 'Pago'");
    $stmt_sacado->execute([$usuario_id]);
    $dados_sacado = $stmt_sacado->fetch();
    $total_ja_pago = $dados_sacado['total_sacado'] ?? 0;

    $saldo_indicacao = $saldo_total_acumulado - $total_ja_pago;

} catch (Exception $e) {
    $mensagem = "Erro ao carregar dados.";
    $tipo_msg = "error";
    $saldo_indicacao = 0.00;
    $total_pagantes = 0;
}

$link_indicacao = "https://ofertaexcelente.com.br/meus/fretes.php?ref=" . $codigo_ref;

// --- UPLOAD DE FOTO ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['foto_perfil']) && $_FILES['foto_perfil']['error'] === 0) {
    $pasta_destino = "uploads/";
    if (!is_dir($pasta_destino)) { mkdir($pasta_destino, 0755, true); }
    $arquivo = $_FILES['foto_perfil'];
    $extensao = strtolower(pathinfo($arquivo['name'], PATHINFO_EXTENSION));
    if (in_array($extensao, ['jpg', 'jpeg', 'png', 'webp'])) {
        $novo_nome = "perfil_" . $usuario_id . "_" . time() . "." . $extensao;
        if (move_uploaded_file($arquivo['tmp_name'], $pasta_destino . $novo_nome)) {
            if ($foto_atual && file_exists($pasta_destino . $foto_atual)) { @unlink($pasta_destino . $foto_atual); }
            $pdo->prepare("UPDATE usuarios SET foto = ? WHERE id = ?")->execute([$novo_nome, $usuario_id]);
            header("Location: perfil.php?sucesso=1"); exit;
        }
    }
}

// --- SOLICITAR SAQUE ---
if (isset($_POST['solicitar_saque']) && $saldo_indicacao >= 50) {
    $stmt_saque = $pdo->prepare("INSERT INTO saques (usuario_id, valor, status) VALUES (?, ?, 'Analisando')");
    $stmt_saque->execute([$usuario_id, $saldo_indicacao]);
    header("Location: perfil.php?msg=saque_enviado"); exit;
}

$stmt_status = $pdo->prepare("SELECT status FROM saques WHERE usuario_id = ? ORDER BY id DESC LIMIT 1");
$stmt_status->execute([$usuario_id]);
$ultimo_saque = $stmt_status->fetch();

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['nova_senha'])) {
    $hash = password_hash($_POST['nova_senha'], PASSWORD_DEFAULT);
    $pdo->prepare("UPDATE usuarios SET senha = ? WHERE id = ?")->execute([$hash, $usuario_id]);
    $mensagem = "Senha atualizada!"; $tipo_msg = "success";
}

if(isset($_GET['sucesso'])) { $mensagem = "Foto atualizada!"; $tipo_msg = "success"; }
if(isset($_GET['msg']) && $_GET['msg'] == 'saque_enviado') { $mensagem = "Solicitação de saque enviada!"; $tipo_msg = "success"; }
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Meu Perfil - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; font-family: 'Inter', sans-serif; }
        .glass-card { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
    </style>
</head>
<body class="text-slate-100 p-4 pb-28">

    <header class="flex items-center gap-4 mb-6 max-w-md mx-auto">
        <a href="painel.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-slate-900 border border-slate-800 text-slate-400">
            <i class="fa-solid fa-chevron-left"></i>
        </a>
        <h1 class="text-lg font-black italic uppercase tracking-tighter text-orange-500">Configurações</h1>
    </header>

    <div class="max-w-md mx-auto space-y-5">
        
        <?php if($mensagem): ?>
            <div class="p-4 rounded-2xl text-center text-[10px] font-black uppercase tracking-widest <?php echo $tipo_msg == 'success' ? 'bg-emerald-500/20 text-emerald-400 border border-emerald-500/50' : 'bg-red-500/20 text-red-400 border border-red-500/50'; ?>">
                <?php echo $mensagem; ?>
            </div>
        <?php endif; ?>

        <div class="glass-card p-8 rounded-[40px] text-center relative overflow-hidden">
            <form action="perfil.php" method="POST" enctype="multipart/form-data" id="formFoto">
                <div class="relative inline-block">
                    <div class="w-24 h-24 bg-orange-500 rounded-3xl mx-auto flex items-center justify-center text-3xl font-black text-slate-950 shadow-xl overflow-hidden rotate-3 border-4 border-slate-800">
                        <?php if($foto_atual && file_exists("uploads/".$foto_atual)): ?>
                            <img src="uploads/<?php echo $foto_atual; ?>" class="w-full h-full object-cover -rotate-3">
                        <?php else: ?>
                            <span class="-rotate-3"><?php echo strtoupper(substr($usuario_nome, 0, 1)); ?></span>
                        <?php endif; ?>
                    </div>
                    <label for="f_perfil" class="absolute -bottom-2 -right-2 bg-white text-slate-900 w-8 h-8 rounded-lg flex items-center justify-center cursor-pointer shadow-xl">
                        <i class="fa-solid fa-camera text-xs"></i>
                    </label>
                    <input type="file" name="foto_perfil" id="f_perfil" class="hidden" accept="image/*" onchange="document.getElementById('formFoto').submit()">
                </div>
            </form>
            <h2 class="text-xl font-black italic mt-4 uppercase leading-none"><?php echo $usuario_nome; ?></h2>
            <p class="text-slate-500 text-[9px] font-black uppercase tracking-[0.2em] mt-3 italic">
                <i class="fa-regular fa-calendar-check text-orange-500 mr-1"></i> Membro desde <?php echo $data_criacao; ?>
            </p>
        </div>

        <div class="glass-card p-6 rounded-[32px] border-t-2 border-emerald-500 shadow-xl shadow-emerald-500/5">
            <div class="flex justify-between items-start mb-6">
                <div>
                    <h3 class="text-[10px] font-black uppercase text-emerald-500 tracking-[0.2em] italic">Carteira de Sócios</h3>
                    <p class="text-[9px] text-slate-400 font-bold uppercase mt-1">
                        <i class="fa-solid fa-users text-emerald-500 mr-1"></i> <?php echo $total_pagantes; ?> Amigos Ativos
                    </p>
                    <p class="text-3xl font-black italic text-white mt-1">R$ <?php echo number_format($saldo_indicacao, 2, ',', '.'); ?></p>
                </div>
                <div class="bg-emerald-500/20 p-3 rounded-2xl text-emerald-500">
                    <i class="fa-solid fa-sack-dollar text-xl"></i>
                </div>
            </div>

            <?php if ($ultimo_saque): ?>
                <div class="bg-slate-950/50 rounded-2xl p-4 mb-4 border border-slate-800 flex items-center justify-between">
                    <span class="text-[9px] font-black uppercase text-slate-500">Último Saque:</span>
                    <span class="text-[10px] font-black uppercase italic text-orange-500 animate-pulse">
                         <?php echo $ultimo_saque['status']; ?>
                    </span>
                </div>
            <?php endif; ?>

            <form method="POST">
                <button type="submit" name="solicitar_saque" 
                        <?php echo ($saldo_indicacao < 50) ? 'disabled' : ''; ?>
                        class="w-full <?php echo ($saldo_indicacao < 50) ? 'bg-slate-800 text-slate-500' : 'bg-emerald-500 text-slate-950'; ?> font-black py-4 rounded-2xl uppercase italic text-[10px] tracking-widest transition-all active:scale-95 shadow-lg">
                    <?php echo ($saldo_indicacao < 50) ? 'Mínimo R$ 50,00 para Saque' : 'Solicitar Saque via PIX'; ?>
                </button>
            </form>
        </div>

        <div class="glass-card p-6 rounded-[32px] space-y-4">
            <div class="flex items-center gap-4">
                <div class="w-10 h-10 rounded-xl bg-slate-900/50 flex items-center justify-center text-orange-500 border border-slate-800">
                    <i class="fa-solid fa-envelope text-sm"></i>
                </div>
                <div class="overflow-hidden">
                    <p class="text-[8px] font-black text-slate-500 uppercase tracking-widest">E-mail Cadastrado</p>
                    <p class="text-xs font-bold text-slate-200 truncate"><?php echo $usuario_email; ?></p>
                </div>
            </div>
            <div class="flex items-center gap-4">
                <div class="w-10 h-10 rounded-xl bg-slate-900/50 flex items-center justify-center text-emerald-500 border border-slate-800">
                    <i class="fa-brands fa-whatsapp text-lg"></i>
                </div>
                <div>
                    <p class="text-[8px] font-black text-slate-500 uppercase tracking-widest">WhatsApp</p>
                    <p class="text-xs font-bold text-slate-200"><?php echo $usuario_whatsapp; ?></p>
                </div>
            </div>
        </div>

        <div class="glass-card p-6 rounded-[32px] border-t-2 border-orange-500">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-[10px] font-black uppercase text-orange-500 tracking-[0.2em] italic">Indicação (Ganha R$ 10,00)</h3>
                <i class="fa-solid fa-share-nodes text-orange-500 text-sm"></i>
            </div>
            <div class="bg-slate-950/50 rounded-2xl p-4 border border-slate-800 mb-4">
                <div class="flex items-center justify-between gap-3">
                    <input type="text" readonly value="<?php echo $link_indicacao; ?>" id="linkInput" class="bg-transparent text-[10px] font-mono text-orange-400 w-full outline-none">
                    <button onclick="copiarLink()" class="bg-slate-800 text-white w-9 h-9 rounded-xl flex items-center shrink-0 justify-center active:scale-90 transition-all">
                        <i class="fa-solid fa-copy text-sm"></i>
                    </button>
                </div>
            </div>
            <a href="https://api.whatsapp.com/send?text=Eai! To usando o ROTA PRIME pra gerenciar meus fretes. Testa aí também: <?php echo $link_indicacao; ?>" target="_blank" class="w-full bg-[#25D366] text-white font-black py-4 rounded-2xl uppercase italic text-[10px] tracking-widest flex items-center justify-center gap-2 shadow-lg">
                <i class="fa-brands fa-whatsapp text-lg"></i> Compartilhar Link
            </a>
        </div>

        <div class="glass-card p-6 rounded-[32px]">
            <h3 class="text-[10px] font-black uppercase text-slate-500 mb-4 italic">Trocar Senha</h3>
            <form method="POST" class="space-y-3">
                <input type="password" name="nova_senha" placeholder="Nova Senha" required class="w-full bg-slate-900 border border-slate-800 rounded-2xl p-4 text-sm text-white">
                <button type="submit" class="w-full bg-orange-500 text-slate-950 font-black py-4 rounded-2xl uppercase italic text-[10px] tracking-widest">Atualizar</button>
            </form>
        </div>

        <a href="logout.php" class="block text-center text-red-500 font-black uppercase text-[10px] tracking-widest p-4">Sair da Conta</a>
    </div>

    <script>
    function copiarLink() {
        var copyText = document.getElementById("linkInput");
        copyText.select();
        navigator.clipboard.writeText(copyText.value);
        alert("Link de indicação copiado!");
    }
    </script>
</body>
</html>