<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once 'config.php';

if (!isset($_SESSION['usuario_id']) || $_SESSION['nivel'] !== 'patrao') {
    header("Location: fretes.php"); exit();
}

$codigo_empresa = $_SESSION['codigo_empresa'];

// --- LÓGICA: SALVAR OU EDITAR VEÍCULO ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['acao'])) {
    $placa = strtoupper(trim($_POST['placa']));
    $modelo = strtoupper(trim($_POST['modelo']));
    $cor = strtoupper(trim($_POST['cor']));
    $id_edit = !empty($_POST['id_edicao']) ? $_POST['id_edicao'] : null;

    if ($id_edit) {
        $stmt = $pdo->prepare("UPDATE veiculos SET placa = ?, modelo = ?, cor = ? WHERE id = ? AND codigo_empresa = ?");
        $stmt->execute([$placa, $modelo, $cor, $id_edit, $codigo_empresa]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO veiculos (codigo_empresa, placa, modelo, cor) VALUES (?, ?, ?, ?)");
        $stmt->execute([$codigo_empresa, $placa, $modelo, $cor]);
    }
    header("Location: veiculos.php"); exit();
}

// --- LÓGICA: EXCLUIR VEÍCULO ---
if (isset($_GET['excluir'])) {
    $stmt = $pdo->prepare("DELETE FROM veiculos WHERE id = ? AND codigo_empresa = ?");
    $stmt->execute([(int)$_GET['excluir'], $codigo_empresa]);
    header("Location: veiculos.php"); exit();
}

// --- BUSCA TODOS OS VEÍCULOS ---
$stmt = $pdo->prepare("SELECT * FROM veiculos WHERE codigo_empresa = ? ORDER BY placa ASC");
$stmt->execute([$codigo_empresa]);
$veiculos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Frota - ROTA PRIME</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background-color: #020617; color: white; font-family: 'Inter', sans-serif; }
        .glass { background: rgba(30, 41, 59, 0.5); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.05); }
        input { background: #0f172a !important; border: 1px solid #1e293b !important; color: white !important; outline: none; }
    </style>
</head>
<body class="pb-20">

    <header class="p-6 max-w-4xl mx-auto flex justify-between items-center">
        <a href="painel_patrao.php" class="text-slate-500 hover:text-white transition-all"><i class="fa-solid fa-arrow-left mr-2"></i> Painel</a>
        <h1 class="text-orange-500 font-black italic text-xl uppercase tracking-tighter text-center">Gestão de <span class="text-white">Frota</span></h1>
        <div class="w-10"></div>
    </header>

    <main class="max-w-4xl mx-auto px-4">
        
        <section class="glass p-6 rounded-[35px] mb-8 border-orange-500/20 shadow-2xl">
            <h3 class="text-[10px] font-black uppercase text-orange-500 mb-4 italic flex items-center gap-2">
                <i class="fa-solid fa-truck-moving"></i> Cadastrar Novo Veículo
            </h3>
            <form method="POST" id="formVeiculo" class="grid grid-cols-1 md:grid-cols-4 gap-3">
                <input type="hidden" name="acao" value="salvar">
                <input type="hidden" name="id_edicao" id="id_edicao">
                
                <input type="text" name="placa" id="in_placa" placeholder="Placa (Ex: ABC1234)" required class="p-4 rounded-2xl text-xs uppercase font-bold">
                <input type="text" name="modelo" id="in_modelo" placeholder="Modelo (Ex: Scania R450)" required class="p-4 rounded-2xl text-xs uppercase font-bold">
                <input type="text" name="cor" id="in_cor" placeholder="Cor" class="p-4 rounded-2xl text-xs uppercase font-bold">
                
                <button type="submit" id="btn_save" class="bg-orange-500 text-slate-950 font-black rounded-2xl text-[10px] uppercase italic hover:bg-orange-400 transition-all">
                    Adicionar Veículo
                </button>
            </form>
        </section>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <?php if(count($veiculos) > 0): foreach($veiculos as $v): ?>
            <div class="glass p-5 rounded-[30px] border border-white/5 flex justify-between items-center group hover:border-orange-500/50 transition-all">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-slate-800 rounded-2xl flex items-center justify-center text-orange-500 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-truck text-xl"></i>
                    </div>
                    <div>
                        <h4 class="font-black italic text-lg uppercase leading-none"><?php echo $v['placa']; ?></h4>
                        <p class="text-[10px] text-slate-500 font-bold uppercase mt-1"><?php echo $v['modelo']; ?> <span class="mx-1">•</span> <?php echo $v['cor']; ?></p>
                    </div>
                </div>
                <div class="flex gap-3">
                    <button onclick="editar('<?php echo $v['id']; ?>','<?php echo $v['placa']; ?>','<?php echo $v['modelo']; ?>','<?php echo $v['cor']; ?>')" class="text-slate-500 hover:text-white transition-colors">
                        <i class="fa-solid fa-pen-to-square"></i>
                    </button>
                    <a href="?excluir=<?php echo $v['id']; ?>" onclick="return confirm('Tem certeza que deseja remover este veículo?')" class="text-slate-700 hover:text-red-500 transition-colors">
                        <i class="fa-solid fa-trash"></i>
                    </a>
                </div>
            </div>
            <?php endforeach; else: ?>
                <div class="col-span-full text-center py-10 opacity-30 italic uppercase text-xs font-bold tracking-widest">
                    Nenhum veículo cadastrado na frota.
                </div>
            <?php endif; ?>
        </div>
    </main>

    <script>
        function editar(id, placa, modelo, cor) {
            document.getElementById('id_edicao').value = id;
            document.getElementById('in_placa').value = placa;
            document.getElementById('in_modelo').value = modelo;
            document.getElementById('in_cor').value = cor;
            document.getElementById('btn_save').innerText = "Atualizar Veículo";
            document.getElementById('btn_save').className = "bg-blue-500 text-white font-black rounded-2xl text-[10px] uppercase italic";
            window.scrollTo({top: 0, behavior: 'smooth'});
        }
    </script>
</body>
</html>